/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.errors;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.RegexErrorHeuristic;

public class ScriptErrorHeuristic
extends RegexErrorHeuristic {
    private static final String FAILED_REGEX = "Script failed with code [0-9]+";

    public ScriptErrorHeuristic() {
        this.setQueryRegex(".*");
        this.getLogRegexes().add(FAILED_REGEX);
    }

    @Override
    public ErrorAndSolution getErrorAndSolution() {
        ErrorAndSolution es = null;
        if (this.getQueryMatches()) {
            for (List<String> matchingLines : this.getRegexToLogLines().values()) {
                if (matchingLines.size() <= 0) continue;
                assert (matchingLines.size() == 1);
                Matcher m1 = Pattern.compile(FAILED_REGEX).matcher(matchingLines.get(0));
                m1.find();
                String failedStr = m1.group();
                Matcher m22 = Pattern.compile("[0-9]+").matcher(failedStr);
                m22.find();
                String errorCode = m22.group();
                es = new ErrorAndSolution("A user-supplied transfrom script has exited with error code " + errorCode + " instead of 0.", "Verify that the script can properly handle all the input rows without throwing exceptions and exits properly.");
            }
        }
        this.reset();
        return es;
    }
}

