/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.errors;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.RegexErrorHeuristic;

public class DataCorruptErrorHeuristic
extends RegexErrorHeuristic {
    private static final String SPLIT_REGEX = "split:\\s*([^\\s]+)";
    private static final String EXCEPTION_REGEX = "EOFException";

    public DataCorruptErrorHeuristic() {
        this.setQueryRegex(".*");
        this.getLogRegexes().add(SPLIT_REGEX);
        this.getLogRegexes().add(EXCEPTION_REGEX);
    }

    @Override
    public ErrorAndSolution getErrorAndSolution() {
        Map<String, List<String>> rll;
        ErrorAndSolution es = null;
        if (this.getQueryMatches() && (rll = this.getRegexToLogLines()).get(EXCEPTION_REGEX).size() > 0 && rll.get(SPLIT_REGEX).size() > 0) {
            String splitLogLine = rll.get(SPLIT_REGEX).get(0);
            Pattern p = Pattern.compile(SPLIT_REGEX, 2);
            Matcher m3 = p.matcher(splitLogLine);
            m3.find();
            String splitStr = m3.group(1);
            es = new ErrorAndSolution("Data file " + splitStr + " is corrupted.", "Replace file. i.e. by re-running the query that produced the source table / partition.");
        }
        this.reset();
        return es;
    }
}

