/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorFileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.Registration;
import org.apache.hive.com.esotericsoftware.kryo.Serializer;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.apache.hive.com.esotericsoftware.kryo.pool.KryoFactory;
import org.apache.hive.com.esotericsoftware.kryo.pool.KryoPool;
import org.apache.hive.com.esotericsoftware.kryo.serializers.FieldSerializer;
import org.apache.hive.org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtilities {
    private static final String CLASS_NAME = SerializationUtilities.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final Map<Class<?>, Hook> kryoTypeHooks = new HashMap();
    private static Hook globalHook = null;
    private static KryoFactory factory = new KryoFactory(){

        @Override
        public Kryo create() {
            KryoWithHooks kryo = new KryoWithHooks();
            kryo.register(Date.class, new SqlDateSerializer());
            kryo.register(Timestamp.class, new TimestampSerializer());
            kryo.register(Path.class, new PathSerializer());
            kryo.register(Arrays.asList("").getClass(), new ArraysAsListSerializer());
            ((Kryo.DefaultInstantiatorStrategy)kryo.getInstantiatorStrategy()).setFallbackInstantiatorStrategy(new StdInstantiatorStrategy());
            SerializationUtilities.removeField(kryo, Operator.class, "colExprMap");
            SerializationUtilities.removeField(kryo, AbstractOperatorDesc.class, "statistics");
            kryo.register(MapWork.class);
            kryo.register(ReduceWork.class);
            kryo.register(TableDesc.class);
            kryo.register(UnionOperator.class);
            kryo.register(FileSinkOperator.class);
            kryo.register(VectorFileSinkOperator.class);
            kryo.register(HiveIgnoreKeyTextOutputFormat.class);
            kryo.register(StandardConstantListObjectInspector.class);
            kryo.register(StandardConstantMapObjectInspector.class);
            kryo.register(StandardConstantStructObjectInspector.class);
            kryo.register(SequenceFileInputFormat.class);
            kryo.register(RCFileInputFormat.class);
            kryo.register(HiveSequenceFileOutputFormat.class);
            kryo.register(SparkEdgeProperty.class);
            kryo.register(SparkWork.class);
            kryo.register(Pair.class);
            return kryo.processHooks(kryoTypeHooks, globalHook);
        }
    };
    private static KryoPool kryoPool = new KryoPool.Builder(factory).softReferences().build();

    public static void addKryoTypeHook(Class<?> clazz, Hook hook) {
        kryoTypeHooks.put(clazz, hook);
    }

    public static void setGlobalHook(Hook hook) {
        globalHook = hook;
    }

    public static Kryo borrowKryo() {
        Kryo kryo = kryoPool.borrow();
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        return kryo;
    }

    public static void releaseKryo(Kryo kryo) {
        kryoPool.release(kryo);
    }

    private static void removeField(Kryo kryo, Class type, String fieldName) {
        FieldSerializer fld = new FieldSerializer(kryo, type);
        fld.removeField(fieldName);
        kryo.register(type, fld);
    }

    public static void serializePlan(Object plan, OutputStream out) {
        SerializationUtilities.serializePlan(plan, out, false);
    }

    public static void serializePlan(Kryo kryo, Object plan, OutputStream out) {
        SerializationUtilities.serializePlan(kryo, plan, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializePlan(Object plan, OutputStream out, boolean cloningPlan) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            SerializationUtilities.serializePlan(kryo, plan, out, cloningPlan);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
    }

    private static void serializePlan(Kryo kryo, Object plan, OutputStream out, boolean cloningPlan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "serializePlan");
        LOG.info("Serializing " + plan.getClass().getSimpleName() + " using kryo");
        if (cloningPlan) {
            SerializationUtilities.serializeObjectByKryo(kryo, plan, out);
        } else {
            SerializationUtilities.serializeObjectByKryo(kryo, plan, out);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "serializePlan");
    }

    public static <T> T deserializePlan(InputStream in, Class<T> planClass) {
        return SerializationUtilities.deserializePlan(in, planClass, false);
    }

    public static <T> T deserializePlan(Kryo kryo, InputStream in, Class<T> planClass) {
        return SerializationUtilities.deserializePlan(kryo, in, planClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T deserializePlan(InputStream in, Class<T> planClass, boolean cloningPlan) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        T result = null;
        try {
            result = SerializationUtilities.deserializePlan(kryo, in, planClass, cloningPlan);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        return result;
    }

    private static <T> T deserializePlan(Kryo kryo, InputStream in, Class<T> planClass, boolean cloningPlan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "deserializePlan");
        LOG.info("Deserializing " + planClass.getSimpleName() + " using kryo");
        T plan = cloningPlan ? SerializationUtilities.deserializeObjectByKryo(kryo, in, planClass) : SerializationUtilities.deserializeObjectByKryo(kryo, in, planClass);
        perfLogger.PerfLogEnd(CLASS_NAME, "deserializePlan");
        return plan;
    }

    public static MapredWork clonePlan(MapredWork plan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "clonePlan");
        Operator<?> op = plan.getAnyOperator();
        CompilationOpContext ctx = op == null ? null : op.getCompilationOpContext();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        SerializationUtilities.serializePlan(plan, baos, true);
        MapredWork newPlan = SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), MapredWork.class, true);
        for (Operator<?> newOp : newPlan.getAllOperators()) {
            newOp.setCompilationOpContext(ctx);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "clonePlan");
        return newPlan;
    }

    public static List<Operator<?>> cloneOperatorTree(List<Operator<?>> roots) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        CompilationOpContext ctx = roots.isEmpty() ? null : roots.get(0).getCompilationOpContext();
        SerializationUtilities.serializePlan(roots, baos, true);
        List result = (List)SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), roots.getClass(), true);
        LinkedList<Operator<OperatorDesc>> newOps = new LinkedList<Operator<OperatorDesc>>(result);
        while (!newOps.isEmpty()) {
            Operator newOp = (Operator)newOps.poll();
            newOp.setCompilationOpContext(ctx);
            List<Operator<OperatorDesc>> children = newOp.getChildOperators();
            if (children == null) continue;
            newOps.addAll(children);
        }
        return result;
    }

    public static List<Operator<?>> cloneOperatorTree(List<Operator<?>> roots, int indexForTezUnion) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        CompilationOpContext ctx = roots.isEmpty() ? null : roots.get(0).getCompilationOpContext();
        SerializationUtilities.serializePlan(roots, baos, true);
        List result = (List)SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), roots.getClass(), true);
        LinkedList<Operator<OperatorDesc>> newOps = new LinkedList<Operator<OperatorDesc>>(result);
        while (!newOps.isEmpty()) {
            Operator newOp = (Operator)newOps.poll();
            newOp.setIndexForTezUnion(indexForTezUnion);
            newOp.setCompilationOpContext(ctx);
            List<Operator<OperatorDesc>> children = newOp.getChildOperators();
            if (children == null) continue;
            newOps.addAll(children);
        }
        return result;
    }

    public static BaseWork cloneBaseWork(BaseWork plan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "clonePlan");
        Operator<? extends OperatorDesc> op = plan.getAnyRootOperator();
        CompilationOpContext ctx = op == null ? null : op.getCompilationOpContext();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        SerializationUtilities.serializePlan(plan, baos, true);
        BaseWork newPlan = (BaseWork)SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), plan.getClass(), true);
        for (Operator<?> newOp : newPlan.getAllOperators()) {
            newOp.setCompilationOpContext(ctx);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "clonePlan");
        return newPlan;
    }

    private static void serializeObjectByKryo(Kryo kryo, Object plan, OutputStream out) {
        Output output = new Output(out);
        kryo.setClassLoader(Utilities.getSessionSpecifiedClassLoader());
        kryo.writeObject(output, plan);
        output.close();
    }

    private static <T> T deserializeObjectByKryo(Kryo kryo, InputStream in, Class<T> clazz) {
        Input inp = new Input(in);
        kryo.setClassLoader(Utilities.getSessionSpecifiedClassLoader());
        T t = kryo.readObject(inp, clazz);
        inp.close();
        return t;
    }

    public static byte[] serializeExpressionToKryo(ExprNodeGenericFuncDesc expr) {
        return SerializationUtilities.serializeObjectToKryo(expr);
    }

    public static ExprNodeGenericFuncDesc deserializeExpressionFromKryo(byte[] bytes) {
        return SerializationUtilities.deserializeObjectFromKryo(bytes, ExprNodeGenericFuncDesc.class);
    }

    public static String serializeExpression(ExprNodeGenericFuncDesc expr) {
        try {
            return new String(Base64.encodeBase64((byte[])SerializationUtilities.serializeExpressionToKryo(expr)), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    public static ExprNodeGenericFuncDesc deserializeExpression(String s2) {
        byte[] bytes;
        try {
            bytes = Base64.decodeBase64((byte[])s2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
        return SerializationUtilities.deserializeExpressionFromKryo(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializeObjectToKryo(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output(baos);
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            kryo.writeObject(output, object);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        output.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Serializable> T deserializeObjectFromKryo(byte[] bytes, Class<T> clazz) {
        Input inp = new Input(new ByteArrayInputStream(bytes));
        Kryo kryo = SerializationUtilities.borrowKryo();
        Serializable func = null;
        try {
            func = (Serializable)kryo.readObject(inp, clazz);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        inp.close();
        return (T)func;
    }

    public static String serializeObject(Serializable expr) {
        try {
            return new String(Base64.encodeBase64((byte[])SerializationUtilities.serializeObjectToKryo(expr)), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    public static <T extends Serializable> T deserializeObject(String s2, Class<T> clazz) {
        try {
            return SerializationUtilities.deserializeObjectFromKryo(Base64.decodeBase64((byte[])s2.getBytes("UTF-8")), clazz);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    private static class ArraysAsListSerializer
    extends Serializer<List<?>> {
        private Field _arrayField;

        public ArraysAsListSerializer() {
            try {
                this._arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
                this._arrayField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setImmutable(true);
        }

        @Override
        public List<?> read(Kryo kryo, Input input, Class<List<?>> type) {
            int length = input.readInt(true);
            Class<?> componentType = kryo.readClass(input).getType();
            if (componentType.isPrimitive()) {
                componentType = this.getPrimitiveWrapperClass(componentType);
            }
            try {
                Object items = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(items, i, kryo.readClassAndObject(input));
                }
                return Arrays.asList((Object[])items);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, List<?> obj) {
            try {
                Object[] array = (Object[])this._arrayField.get(obj);
                output.writeInt(array.length, true);
                Class<?> componentType = array.getClass().getComponentType();
                kryo.writeClass(output, componentType);
                for (Object item : array) {
                    kryo.writeClassAndObject(output, item);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class<?> getPrimitiveWrapperClass(Class<?> c) {
            if (c.isPrimitive()) {
                if (c.equals(Long.TYPE)) {
                    return Long.class;
                }
                if (c.equals(Integer.TYPE)) {
                    return Integer.class;
                }
                if (c.equals(Double.TYPE)) {
                    return Double.class;
                }
                if (c.equals(Float.TYPE)) {
                    return Float.class;
                }
                if (c.equals(Boolean.TYPE)) {
                    return Boolean.class;
                }
                if (c.equals(Character.TYPE)) {
                    return Character.class;
                }
                if (c.equals(Short.TYPE)) {
                    return Short.class;
                }
                if (c.equals(Byte.TYPE)) {
                    return Byte.class;
                }
            }
            return c;
        }
    }

    private static class PathSerializer
    extends Serializer<Path> {
        private PathSerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, Path path) {
            output.writeString(path.toUri().toString());
        }

        @Override
        public Path read(Kryo kryo, Input input, Class<Path> type) {
            return new Path(URI.create(input.readString()));
        }
    }

    private static class SqlDateSerializer
    extends Serializer<Date> {
        private SqlDateSerializer() {
        }

        @Override
        public Date read(Kryo kryo, Input input, Class<Date> clazz) {
            return new Date(input.readLong());
        }

        @Override
        public void write(Kryo kryo, Output output, Date sqlDate) {
            output.writeLong(sqlDate.getTime());
        }
    }

    private static class TimestampSerializer
    extends Serializer<Timestamp> {
        private TimestampSerializer() {
        }

        @Override
        public Timestamp read(Kryo kryo, Input input, Class<Timestamp> clazz) {
            Timestamp ts = new Timestamp(input.readLong());
            ts.setNanos(input.readInt());
            return ts;
        }

        @Override
        public void write(Kryo kryo, Output output, Timestamp ts) {
            output.writeLong(ts.getTime());
            output.writeInt(ts.getNanos());
        }
    }

    private static class KryoWithHooks
    extends Kryo {
        private Hook globalHook;

        private KryoWithHooks() {
        }

        public Kryo processHooks(Map<Class<?>, Hook> hooks, Hook globalHook) {
            for (Map.Entry<Class<?>, Hook> e : hooks.entrySet()) {
                this.register(e.getKey(), new SerializerWithHook(this.newDefaultSerializer(e.getKey()), e.getValue()));
            }
            this.globalHook = globalHook;
            return this;
        }

        private Hook ponderGlobalPreReadHook(Class<?> clazz) {
            Hook globalHook = this.globalHook;
            return globalHook != null && globalHook.preRead(clazz) ? globalHook : null;
        }

        private <T> T ponderGlobalPostReadHook(Hook hook, T result) {
            return (T)(hook == null ? result : hook.postRead(result));
        }

        private Object ponderGlobalPostHook(Object result) {
            Hook globalHook = this.globalHook;
            return globalHook != null ? globalHook.postRead(result) : result;
        }

        @Override
        public Object readClassAndObject(Input input) {
            return this.ponderGlobalPostHook(super.readClassAndObject(input));
        }

        @Override
        public Registration readClass(Input input) {
            Registration reg = super.readClass(input);
            if (reg != null) {
                this.ponderGlobalPreReadHook(reg.getType());
            }
            return reg;
        }

        @Override
        public <T> T readObjectOrNull(Input input, Class<T> type) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            T result = super.readObjectOrNull(input, type);
            return this.ponderGlobalPostReadHook(hook, result);
        }

        @Override
        public <T> T readObjectOrNull(Input input, Class<T> type, Serializer serializer) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            T result = super.readObjectOrNull(input, type, serializer);
            return this.ponderGlobalPostReadHook(hook, result);
        }

        @Override
        public <T> T readObject(Input input, Class<T> type) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            T result = super.readObject(input, type);
            return this.ponderGlobalPostReadHook(hook, result);
        }

        @Override
        public <T> T readObject(Input input, Class<T> type, Serializer serializer) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            T result = super.readObject(input, type, serializer);
            return this.ponderGlobalPostReadHook(hook, result);
        }

        private static final class SerializerWithHook
        extends Serializer {
            private final Serializer old;
            private final Hook hook;

            private SerializerWithHook(Serializer old, Hook hook) {
                this.old = old;
                this.hook = hook;
            }

            public Object read(Kryo kryo, Input input, Class type) {
                return this.hook.preRead(type) ? this.hook.postRead(this.old.read(kryo, input, type)) : this.old.read(kryo, input, type);
            }

            public void write(Kryo kryo, Output output, Object object) {
                this.old.write(kryo, output, object);
            }
        }
    }

    public static class Hook {
        public boolean preRead(Class<?> type) {
            return true;
        }

        public Object postRead(Object o) {
            return o;
        }
    }
}

