/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.hbase.stats.IExtrapolatePartStatus;

public class LongColumnStatsAggregator
extends ColumnStatsAggregator
implements IExtrapolatePartStatus {
    @Override
    public ColumnStatisticsObj aggregate(String colName, List<String> partNames, List<ColumnStatistics> css) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        boolean doAllPartitionContainStats = partNames.size() == css.size();
        boolean isNDVBitVectorSet = true;
        String colType = null;
        for (ColumnStatistics cs : css) {
            if (cs.getStatsObjSize() != 1) {
                throw new MetaException("The number of columns should be exactly one in aggrStats, but found " + cs.getStatsObjSize());
            }
            ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
            if (statsObj == null) {
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
            }
            if (this.numBitVectors > 0 && cso.getStatsData().getLongStats().isSetBitVectors() && cso.getStatsData().getLongStats().getBitVectors().length() != 0) continue;
            isNDVBitVectorSet = false;
            break;
        }
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (doAllPartitionContainStats || css.size() < 2) {
            LongColumnStatsData aggregateData = null;
            long lowerBound = 0L;
            long higherBound = 0L;
            double densityAvgSum = 0.0;
            NumDistinctValueEstimator ndvEstimator = null;
            if (isNDVBitVectorSet) {
                ndvEstimator = new NumDistinctValueEstimator(this.numBitVectors);
            }
            for (ColumnStatistics cs : css) {
                ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
                LongColumnStatsData newData = cso.getStatsData().getLongStats();
                if (this.useDensityFunctionForNDVEstimation) {
                    lowerBound = Math.max(lowerBound, newData.getNumDVs());
                    higherBound += newData.getNumDVs();
                    densityAvgSum += (double)((newData.getHighValue() - newData.getLowValue()) / newData.getNumDVs());
                }
                if (isNDVBitVectorSet) {
                    ndvEstimator.mergeEstimators(new NumDistinctValueEstimator(newData.getBitVectors(), ndvEstimator.getnumBitVectors()));
                }
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
                aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            if (isNDVBitVectorSet) {
                aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            } else if (this.useDensityFunctionForNDVEstimation) {
                double densityAvg = densityAvgSum / (double)partNames.size();
                long estimation = (long)((double)(aggregateData.getHighValue() - aggregateData.getLowValue()) / densityAvg);
                if (estimation < lowerBound) {
                    aggregateData.setNumDVs(lowerBound);
                } else if (estimation > higherBound) {
                    aggregateData.setNumDVs(higherBound);
                } else {
                    aggregateData.setNumDVs(estimation);
                }
            }
            columnStatisticsData.setLongStats(aggregateData);
        } else {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap<String, Double> adjustedIndexMap = new HashMap<String, Double>();
            HashMap<String, ColumnStatisticsData> adjustedStatsMap = new HashMap<String, ColumnStatisticsData>();
            double densityAvgSum = 0.0;
            if (!isNDVBitVectorSet) {
                for (ColumnStatistics cs : css) {
                    String partName = cs.getStatsDesc().getPartName();
                    ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
                    LongColumnStatsData newData = cso.getStatsData().getLongStats();
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)((newData.getHighValue() - newData.getLowValue()) / newData.getNumDVs());
                    }
                    adjustedIndexMap.put(partName, (double)((Integer)indexMap.get(partName)));
                    adjustedStatsMap.put(partName, cso.getStatsData());
                }
            } else {
                NumDistinctValueEstimator ndvEstimator = new NumDistinctValueEstimator(this.numBitVectors);
                StringBuilder pseudoPartName = new StringBuilder();
                double pseudoIndexSum = 0.0;
                int length = 0;
                int curIndex = -1;
                LongColumnStatsData aggregateData = null;
                for (ColumnStatistics cs : css) {
                    String partName = cs.getStatsDesc().getPartName();
                    ColumnStatisticsObj cso = cs.getStatsObjIterator().next();
                    LongColumnStatsData newData = cso.getStatsData().getLongStats();
                    if ((Integer)indexMap.get(partName) != curIndex) {
                        if (length > 0) {
                            adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                            ColumnStatisticsData csd = new ColumnStatisticsData();
                            csd.setLongStats(aggregateData);
                            adjustedStatsMap.put(pseudoPartName.toString(), csd);
                            if (this.useDensityFunctionForNDVEstimation) {
                                densityAvgSum += (double)((aggregateData.getHighValue() - aggregateData.getLowValue()) / aggregateData.getNumDVs());
                            }
                            pseudoPartName = new StringBuilder();
                            pseudoIndexSum = 0.0;
                            length = 0;
                        }
                        aggregateData = null;
                    }
                    curIndex = (Integer)indexMap.get(partName);
                    pseudoPartName.append(partName);
                    pseudoIndexSum += (double)curIndex;
                    ++length;
                    ++curIndex;
                    if (aggregateData == null) {
                        aggregateData = newData.deepCopy();
                    } else {
                        aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
                        aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
                        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                    }
                    ndvEstimator.mergeEstimators(new NumDistinctValueEstimator(newData.getBitVectors(), ndvEstimator.getnumBitVectors()));
                }
                if (length > 0) {
                    adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                    aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                    ColumnStatisticsData csd = new ColumnStatisticsData();
                    csd.setLongStats(aggregateData);
                    adjustedStatsMap.put(pseudoPartName.toString(), csd);
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)((aggregateData.getHighValue() - aggregateData.getLowValue()) / aggregateData.getNumDVs());
                    }
                }
            }
            this.extrapolate(columnStatisticsData, partNames.size(), css.size(), adjustedIndexMap, adjustedStatsMap, densityAvgSum / (double)adjustedStatsMap.size());
        }
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    @Override
    public void extrapolate(ColumnStatisticsData extrapolateData, int numParts, int numPartsWithStats, Map<String, Double> adjustedIndexMap, Map<String, ColumnStatisticsData> adjustedStatsMap, double densityAvg) {
        int rightBorderInd = numParts;
        LongColumnStatsData extrapolateLongData = new LongColumnStatsData();
        HashMap<String, LongColumnStatsData> extractedAdjustedStatsMap = new HashMap<String, LongColumnStatsData>();
        for (Map.Entry<String, ColumnStatisticsData> entry : adjustedStatsMap.entrySet()) {
            extractedAdjustedStatsMap.put(entry.getKey(), entry.getValue().getLongStats());
        }
        LinkedList list = new LinkedList(extractedAdjustedStatsMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, LongColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, LongColumnStatsData> o1, Map.Entry<String, LongColumnStatsData> o2) {
                return o1.getValue().getLowValue() < o2.getValue().getLowValue() ? -1 : 1;
            }
        });
        double minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        double maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long lowValue = 0L;
        long min2 = ((LongColumnStatsData)((Map.Entry)list.get(0)).getValue()).getLowValue();
        long max = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getLowValue();
        lowValue = minInd == maxInd ? min2 : (minInd < maxInd ? (long)((double)max - (double)(max - min2) * maxInd / (maxInd - minInd)) : (long)((double)max - (double)(max - min2) * ((double)rightBorderInd - maxInd) / (minInd - maxInd)));
        Collections.sort(list, new Comparator<Map.Entry<String, LongColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, LongColumnStatsData> o1, Map.Entry<String, LongColumnStatsData> o2) {
                return o1.getValue().getHighValue() < o2.getValue().getHighValue() ? -1 : 1;
            }
        });
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long highValue = 0L;
        min2 = ((LongColumnStatsData)((Map.Entry)list.get(0)).getValue()).getHighValue();
        max = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getHighValue();
        highValue = minInd == maxInd ? min2 : (minInd < maxInd ? (long)((double)min2 + (double)(max - min2) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min2 + (double)(max - min2) * minInd / (minInd - maxInd)));
        long numNulls = 0L;
        for (Map.Entry entry : extractedAdjustedStatsMap.entrySet()) {
            numNulls += ((LongColumnStatsData)entry.getValue()).getNumNulls();
        }
        numNulls = numNulls * (long)numParts / (long)numPartsWithStats;
        long ndv = 0L;
        Collections.sort(list, new Comparator<Map.Entry<String, LongColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, LongColumnStatsData> o1, Map.Entry<String, LongColumnStatsData> o2) {
                return o1.getValue().getNumDVs() < o2.getValue().getNumDVs() ? -1 : 1;
            }
        });
        long lowerBound = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
        long higherBound = 0L;
        for (Map.Entry entry : list) {
            higherBound += ((LongColumnStatsData)entry.getValue()).getNumDVs();
        }
        if (this.useDensityFunctionForNDVEstimation && densityAvg != 0.0) {
            ndv = (long)((double)(highValue - lowValue) / densityAvg);
            if (ndv < lowerBound) {
                ndv = lowerBound;
            } else if (ndv > higherBound) {
                ndv = higherBound;
            }
        } else {
            minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
            maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
            min2 = ((LongColumnStatsData)((Map.Entry)list.get(0)).getValue()).getNumDVs();
            max = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
            ndv = minInd == maxInd ? min2 : (minInd < maxInd ? (long)((double)min2 + (double)(max - min2) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min2 + (double)(max - min2) * minInd / (minInd - maxInd)));
        }
        extrapolateLongData.setLowValue(lowValue);
        extrapolateLongData.setHighValue(highValue);
        extrapolateLongData.setNumNulls(numNulls);
        extrapolateLongData.setNumDVs(ndv);
        extrapolateData.setLongStats(extrapolateLongData);
    }
}

