/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jodd.JoddCore;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    private static final String[] MANIFESTS = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = ClassLoaderUtil.getContextClassLoader();
        if (cl == null) {
            Class callerClass = ReflectUtil.getCallerClass(2);
            cl = callerClass.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static void addFileToClassPath(File path, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.addUrlToClassPath(FileUtil.toURL(path), classLoader);
        }
        catch (MalformedURLException muex) {
            throw new IllegalArgumentException("Invalid path: " + path, muex);
        }
    }

    public static void addUrlToClassPath(URL url, ClassLoader classLoader) {
        try {
            ReflectUtil.invokeDeclared(URLClassLoader.class, (Object)classLoader, "addURL", new Class[]{URL.class}, new Object[]{url});
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Add URL failed: " + url, ex);
        }
    }

    public static Class defineClass(String className, byte[] classData) {
        return ClassLoaderUtil.defineClass(className, classData, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static Class defineClass(String className, byte[] classData, ClassLoader classLoader) {
        try {
            return (Class)ReflectUtil.invokeDeclared(ClassLoader.class, (Object)classLoader, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{className, classData, 0, classData.length});
        }
        catch (Throwable th) {
            throw new RuntimeException("Define class failed: " + className, th);
        }
    }

    public static Class findClass(String className, File[] classPath, ClassLoader parent) {
        URL[] urls = new URL[classPath.length];
        for (int i = 0; i < classPath.length; ++i) {
            File file = classPath[i];
            try {
                urls[i] = FileUtil.toURL(file);
                continue;
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        return ClassLoaderUtil.findClass(className, urls, null);
    }

    public static Class findClass(String className, URL[] classPath, ClassLoader parent) {
        URLClassLoader tempClassLoader = parent != null ? new URLClassLoader(classPath, parent) : new URLClassLoader(classPath);
        try {
            return (Class)ReflectUtil.invokeDeclared(URLClassLoader.class, (Object)tempClassLoader, "findClass", new Class[]{String.class}, new Object[]{className});
        }
        catch (Throwable th) {
            throw new RuntimeException("Class not found: " + className, th);
        }
    }

    public static File findToolsJar() {
        String tools = new File(SystemUtil.getJavaHome()).getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "tools.jar";
        File toolsFile = new File(tools);
        if (toolsFile.exists()) {
            return toolsFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getClasspathItemManifest(File classpathItem) {
        Manifest manifest = null;
        if (classpathItem.isFile()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(classpathItem);
                    JarFile jar = new JarFile(classpathItem);
                    manifest = jar.getManifest();
                }
                catch (IOException ignore) {
                    Object var5_8 = null;
                    StreamUtil.close(fis);
                    return manifest;
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                StreamUtil.close(fis);
                throw throwable;
            }
            StreamUtil.close(fis);
            return manifest;
        }
        File metaDir = new File(classpathItem, "META-INF");
        File manifestFile = null;
        if (metaDir.isDirectory()) {
            for (String m3 : MANIFESTS) {
                File mFile = new File(metaDir, m3);
                if (!mFile.isFile()) continue;
                manifestFile = mFile;
                break;
            }
        }
        if (manifestFile == null) return manifest;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(manifestFile);
                manifest = new Manifest(fis);
            }
            catch (IOException ignore) {
                Object var10_18 = null;
                StreamUtil.close(fis);
                return manifest;
            }
            Object var10_17 = null;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            StreamUtil.close(fis);
            throw throwable;
        }
        StreamUtil.close(fis);
        return manifest;
    }

    public static String getClasspathItemBaseDir(File classpathItem) {
        String base = classpathItem.isFile() ? classpathItem.getParent() : classpathItem.toString();
        return base;
    }

    public static File[] getDefaultClasspath() {
        return ClassLoaderUtil.getDefaultClasspath(ClassLoaderUtil.getDefaultClassLoader());
    }

    public static File[] getDefaultClasspath(ClassLoader classLoader) {
        TreeSet<File> classpaths = new TreeSet<File>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URL[] urls;
                for (URL u : urls = ((URLClassLoader)classLoader).getURLs()) {
                    File f = FileUtil.toFile(u);
                    if (f == null || !f.exists()) continue;
                    try {
                        f = f.getCanonicalFile();
                        boolean newElement = classpaths.add(f);
                        if (!newElement) continue;
                        ClassLoaderUtil.addInnerClasspathItems(classpaths, f);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            classLoader = classLoader.getParent();
        }
        String bootstrap = SystemUtil.getSunBoothClassPath();
        if (bootstrap != null) {
            String[] bootstrapFiles;
            for (String bootstrapFile : bootstrapFiles = StringUtil.splitc(bootstrap, File.pathSeparatorChar)) {
                File f = new File(bootstrapFile);
                if (!f.exists()) continue;
                try {
                    f = f.getCanonicalFile();
                    boolean newElement = classpaths.add(f);
                    if (!newElement) continue;
                    ClassLoaderUtil.addInnerClasspathItems(classpaths, f);
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
        File[] result = new File[classpaths.size()];
        return classpaths.toArray(result);
    }

    private static void addInnerClasspathItems(Set<File> classpaths, File item) {
        String[] tokens;
        Manifest manifest = ClassLoaderUtil.getClasspathItemManifest(item);
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String s2 = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (s2 == null) {
            return;
        }
        String base = ClassLoaderUtil.getClasspathItemBaseDir(item);
        for (String t : tokens = StringUtil.splitc(s2, ' ')) {
            File file;
            try {
                file = new File(base, t);
                file = file.getCanonicalFile();
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception ignore) {
                file = null;
            }
            if (file == null) {
                try {
                    file = new File(t);
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception ignore) {
                    file = null;
                }
            }
            if (file == null) {
                try {
                    URL url = new URL(t);
                    file = new File(url.getFile());
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception ignore) {
                    file = null;
                }
            }
            if (file == null || !file.exists()) continue;
            classpaths.add(file);
        }
    }

    public static URL getResourceUrl(String resourceName) {
        return ClassLoaderUtil.getResourceUrl(resourceName, null);
    }

    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        URL resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        Class callerClass = ReflectUtil.getCallerClass(2);
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader && (resourceUrl = callerClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        return null;
    }

    public static File getResourceFile(String resourceName) {
        return ClassLoaderUtil.getResourceFile(resourceName, null);
    }

    public static File getResourceFile(String resourceName, ClassLoader classLoader) {
        try {
            return new File(ClassLoaderUtil.getResourceUrl(resourceName, classLoader).toURI());
        }
        catch (URISyntaxException ignore) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        URL url = ClassLoaderUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class clazz) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(clazz), clazz.getClassLoader());
    }

    public static InputStream getClassAsStream(String className) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(className));
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return JoddCore.classLoaderStrategy.loadClass(className, null);
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return JoddCore.classLoaderStrategy.loadClass(className, classLoader);
    }

    public static String getClassFileName(Class clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return ClassLoaderUtil.getClassFileName(clazz.getName());
    }

    public static String getClassFileName(String className) {
        return className.replace('.', '/') + ".class";
    }
}

