/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastBitSet
extends FastCollection<Index>
implements Set<Index>,
Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastBitSet();
        }
    };
    private long[] bits;
    private int _length;
    private static final long serialVersionUID = 1L;

    public FastBitSet() {
        this(64);
    }

    public FastBitSet(int bitSize) {
        this._length = (bitSize - 1 >> 6) + 1;
        this.bits = new long[this._length];
    }

    public static FastBitSet newInstance() {
        FastBitSet bitSet = (FastBitSet)FACTORY.object();
        bitSet._length = 0;
        return bitSet;
    }

    public static void recycle(FastBitSet instance) {
        FACTORY.recycle(instance);
    }

    @Override
    public boolean add(Index index) {
        int bitIndex = index.intValue();
        if (this.get(bitIndex)) {
            return false;
        }
        this.set(bitIndex);
        return true;
    }

    public void and(FastBitSet that) {
        int n = MathLib.min(this._length, that._length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & that.bits[i];
        }
        this._length = n;
    }

    public void andNot(FastBitSet that) {
        int i = Math.min(this._length, that._length);
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] & (that.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this._length; ++i) {
            sum += MathLib.bitCount(this.bits[i]);
        }
        return sum;
    }

    @Override
    public void clear() {
        this._length = 0;
    }

    public void clear(int bitIndex) {
        int longIndex = bitIndex >> 6;
        if (longIndex >= this._length) {
            return;
        }
        int n = longIndex;
        this.bits[n] = this.bits[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int i = fromIndex >>> 6;
        if (i >= this._length) {
            return;
        }
        int j = toIndex >>> 6;
        if (i == j) {
            int n = i;
            this.bits[n] = this.bits[n] & ((1L << fromIndex) - 1L | -1L << toIndex);
            return;
        }
        int n = i;
        this.bits[n] = this.bits[n] & (1L << fromIndex) - 1L;
        if (j < this._length) {
            int n2 = j;
            this.bits[n2] = this.bits[n2] & -1L << toIndex;
        }
        for (int k = i + 1; k < j && k < this._length; ++k) {
            this.bits[k] = 0L;
        }
    }

    public void flip(int bitIndex) {
        int i = bitIndex >> 6;
        this.setLength(i + 1);
        int n = i;
        this.bits[n] = this.bits[n] ^ 1L << bitIndex;
    }

    public void flip(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int i = fromIndex >>> 6;
        int j = toIndex >>> 6;
        this.setLength(j + 1);
        if (i == j) {
            int n = i;
            this.bits[n] = this.bits[n] ^ -1L << fromIndex & (1L << toIndex) - 1L;
            return;
        }
        int n = i;
        this.bits[n] = this.bits[n] ^ -1L << fromIndex;
        int n2 = j;
        this.bits[n2] = this.bits[n2] ^ (1L << toIndex) - 1L;
        int k = i + 1;
        while (k < j) {
            int n3 = k++;
            this.bits[n3] = this.bits[n3] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public boolean get(int bitIndex) {
        int i = bitIndex >> 6;
        return i >= this._length ? false : (this.bits[i] & 1L << bitIndex) != 0L;
    }

    public FastBitSet get(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        FastBitSet bitSet = FastBitSet.newInstance();
        int length = MathLib.min(this._length, (toIndex >>> 6) + 1);
        bitSet.setLength(length);
        System.arraycopy(this.bits, 0, bitSet.bits, 0, length);
        bitSet.clear(0, fromIndex);
        bitSet.clear(toIndex, length << 6);
        return bitSet;
    }

    public boolean intersects(FastBitSet that) {
        int i = MathLib.min(this._length, that._length);
        while (--i >= 0) {
            if ((this.bits[i] & that.bits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int length() {
        int i = this._length;
        while (--i >= 0) {
            long l = this.bits[i];
            if (l == 0L) continue;
            return i << 70 - MathLib.numberOfTrailingZeros(l);
        }
        return 0;
    }

    public int nextClearBit(int fromIndex) {
        long mask = 1L << fromIndex;
        for (int offset = fromIndex >> 6; offset < this._length; ++offset) {
            long h2 = this.bits[offset];
            do {
                if ((h2 & mask) == 0L) {
                    return fromIndex;
                }
                ++fromIndex;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
        }
        return fromIndex;
    }

    public int nextSetBit(int fromIndex) {
        long mask = 1L << fromIndex;
        for (int offset = fromIndex >> 6; offset < this._length; ++offset) {
            long h2 = this.bits[offset];
            do {
                if ((h2 & mask) != 0L) {
                    return fromIndex;
                }
                ++fromIndex;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
        }
        return -1;
    }

    public void or(FastBitSet that) {
        if (that._length > this._length) {
            this.setLength(that._length);
        }
        int i = that._length;
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] | that.bits[i];
        }
    }

    public void set(int bitIndex) {
        int i = bitIndex >> 6;
        if (i >= this._length) {
            this.setLength(i + 1);
        }
        int n = i;
        this.bits[n] = this.bits[n] | 1L << bitIndex;
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int i = fromIndex >>> 6;
        int j = toIndex >>> 6;
        this.setLength(j + 1);
        if (i == j) {
            int n = i;
            this.bits[n] = this.bits[n] | -1L << fromIndex & (1L << toIndex) - 1L;
            return;
        }
        int n = i;
        this.bits[n] = this.bits[n] | -1L << fromIndex;
        int n2 = j;
        this.bits[n2] = this.bits[n2] | (1L << toIndex) - 1L;
        for (int k = i + 1; k < j; ++k) {
            this.bits[k] = -1L;
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public int size() {
        return this.cardinality();
    }

    public void xor(FastBitSet that) {
        if (that._length > this._length) {
            this.setLength(that._length);
        }
        int i = that._length;
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ that.bits[i];
        }
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof FastBitSet)) {
            return super.equals(obj);
        }
        FastBitSet that = (FastBitSet)obj;
        int n = MathLib.min(this._length, that._length);
        for (i = 0; i < n; ++i) {
            if (this.bits[i] == that.bits[i]) continue;
            return false;
        }
        for (i = n; i < this._length; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        for (i = n; i < that._length; ++i) {
            if (that.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int i = this.nextSetBit(0);
        while (i >= 0) {
            h2 += i;
            i = this.nextSetBit(i);
        }
        return h2;
    }

    @Override
    public void reset() {
        this._length = 0;
    }

    @Override
    public FastCollection.Record head() {
        return Index.valueOf(-1);
    }

    @Override
    public FastCollection.Record tail() {
        return Index.valueOf(this.cardinality());
    }

    @Override
    public Index valueOf(FastCollection.Record record) {
        int i = ((Index)record).intValue();
        int count = 0;
        int j = 0;
        while (j < this._length) {
            long l;
            if ((count += MathLib.bitCount(l = this.bits[j++])) <= i) continue;
            int bitIndex = j << 6;
            while (count != i) {
                int shiftRight = MathLib.numberOfLeadingZeros(l) + 1;
                l <<= shiftRight;
                bitIndex -= shiftRight;
                --count;
            }
            return Index.valueOf(bitIndex);
        }
        return null;
    }

    @Override
    public void delete(FastCollection.Record record) {
        Index bitIndex = this.valueOf(record);
        if (bitIndex != null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final void setLength(final int newLength) {
        if (this.bits.length < newLength) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    int arrayLength;
                    for (arrayLength = FastBitSet.this.bits.length; arrayLength < newLength; arrayLength <<= 1) {
                    }
                    long[] tmp = new long[arrayLength];
                    System.arraycopy(FastBitSet.this.bits, 0, tmp, 0, FastBitSet.this._length);
                    FastBitSet.access$002(FastBitSet.this, tmp);
                }
            });
        }
        for (int i = this._length; i < newLength; ++i) {
            this.bits[i] = 0L;
        }
        this._length = newLength;
    }

    static /* synthetic */ long[] access$002(FastBitSet x0, long[] x1) {
        x0.bits = x1;
        return x1;
    }
}

