/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.metric.SourceMetricData;

class DynamicKafkaDeserializationSchema
implements KafkaDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final DeserializationSchema<RowData> keyDeserialization;
    private final DeserializationSchema<RowData> valueDeserialization;
    private final boolean hasMetadata;
    private final BufferingCollector keyCollector;
    private final OutputProjectionCollector outputCollector;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean upsertMode;
    private final String inlongMetric;
    private SourceMetricData metricData;
    private String inLongGroupId;
    private String auditHostAndPorts;
    private String inLongStreamId;
    private transient AuditImp auditImp;

    DynamicKafkaDeserializationSchema(int physicalArity, @Nullable DeserializationSchema<RowData> keyDeserialization, int[] keyProjection, DeserializationSchema<RowData> valueDeserialization, int[] valueProjection, boolean hasMetadata, MetadataConverter[] metadataConverters, TypeInformation<RowData> producedTypeInfo, boolean upsertMode, String inLongMetric, String auditHostAndPorts) {
        if (upsertMode) {
            Preconditions.checkArgument((keyDeserialization != null && keyProjection.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for deserialization schema.");
        }
        this.keyDeserialization = keyDeserialization;
        this.valueDeserialization = valueDeserialization;
        this.hasMetadata = hasMetadata;
        this.keyCollector = new BufferingCollector();
        this.outputCollector = new OutputProjectionCollector(physicalArity, keyProjection, valueProjection, metadataConverters, upsertMode);
        this.producedTypeInfo = producedTypeInfo;
        this.upsertMode = upsertMode;
        this.inlongMetric = inLongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        if (this.keyDeserialization != null) {
            this.keyDeserialization.open(context);
        }
        this.valueDeserialization.open(context);
        if (this.inlongMetric != null && !this.inlongMetric.isEmpty()) {
            String[] inLongMetricArray = this.inlongMetric.split("&");
            this.inLongGroupId = inLongMetricArray[0];
            this.inLongStreamId = inLongMetricArray[1];
            String nodeId = inLongMetricArray[2];
            this.metricData = new SourceMetricData(this.inLongGroupId, this.inLongStreamId, nodeId, context.getMetricGroup());
            this.metricData.registerMetricsForNumBytesIn();
            this.metricData.registerMetricsForNumBytesInPerSecond();
            this.metricData.registerMetricsForNumRecordsIn();
            this.metricData.registerMetricsForNumRecordsInPerSecond();
        }
        if (this.auditHostAndPorts != null) {
            AuditImp.getInstance().setAuditProxy(new HashSet<String>(Arrays.asList(this.auditHostAndPorts.split("&"))));
            this.auditImp = AuditImp.getInstance();
        }
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public RowData deserialize(ConsumerRecord<byte[], byte[]> record) throws Exception {
        throw new IllegalStateException("A collector is required for deserializing.");
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> record, Collector<RowData> collector) throws Exception {
        if (this.keyDeserialization == null && !this.hasMetadata) {
            this.valueDeserialization.deserialize(record.value(), collector);
            this.outputMetrics(record);
            return;
        }
        if (this.keyDeserialization != null) {
            this.keyDeserialization.deserialize(record.key(), (Collector)this.keyCollector);
        }
        this.outputCollector.inputRecord = record;
        this.outputCollector.physicalKeyRows = this.keyCollector.buffer;
        this.outputCollector.outputCollector = collector;
        if (record.value() == null && this.upsertMode) {
            this.outputCollector.collect(null);
        } else {
            this.valueDeserialization.deserialize(record.value(), (Collector)this.outputCollector);
            this.outputMetrics(record);
        }
        this.keyCollector.buffer.clear();
    }

    private void outputMetrics(ConsumerRecord<byte[], byte[]> record) {
        this.outputMetricForFlink(record);
        this.outputMetricForAudit(record);
    }

    private void outputMetricForAudit(ConsumerRecord<byte[], byte[]> record) {
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_INPUT, this.inLongGroupId, this.inLongStreamId, System.currentTimeMillis(), 1L, record.value().length);
        }
    }

    private void outputMetricForFlink(ConsumerRecord<byte[], byte[]> record) {
        if (this.metricData != null) {
            this.metricData.getNumBytesIn().inc((long)record.value().length);
            this.metricData.getNumRecordsIn().inc(1L);
        }
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    private static final class OutputProjectionCollector
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int physicalArity;
        private final int[] keyProjection;
        private final int[] valueProjection;
        private final MetadataConverter[] metadataConverters;
        private final boolean upsertMode;
        private transient ConsumerRecord<?, ?> inputRecord;
        private transient List<RowData> physicalKeyRows;
        private transient Collector<RowData> outputCollector;

        OutputProjectionCollector(int physicalArity, int[] keyProjection, int[] valueProjection, MetadataConverter[] metadataConverters, boolean upsertMode) {
            this.physicalArity = physicalArity;
            this.keyProjection = keyProjection;
            this.valueProjection = valueProjection;
            this.metadataConverters = metadataConverters;
            this.upsertMode = upsertMode;
        }

        public void collect(RowData physicalValueRow) {
            if (this.keyProjection.length == 0) {
                this.emitRow(null, (GenericRowData)physicalValueRow);
                return;
            }
            for (RowData physicalKeyRow : this.physicalKeyRows) {
                this.emitRow((GenericRowData)physicalKeyRow, (GenericRowData)physicalValueRow);
            }
        }

        public void close() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void emitRow(@Nullable GenericRowData physicalKeyRow, @Nullable GenericRowData physicalValueRow) {
            RowKind rowKind;
            if (physicalValueRow == null) {
                if (!this.upsertMode) throw new DeserializationException("Invalid null value received in non-upsert mode. Could not to set row kind for output record.");
                rowKind = RowKind.DELETE;
            } else {
                rowKind = physicalValueRow.getRowKind();
            }
            int metadataArity = this.metadataConverters.length;
            GenericRowData producedRow = new GenericRowData(rowKind, this.physicalArity + metadataArity);
            for (int keyPos = 0; keyPos < this.keyProjection.length; ++keyPos) {
                assert (physicalKeyRow != null);
                producedRow.setField(this.keyProjection[keyPos], physicalKeyRow.getField(keyPos));
            }
            if (physicalValueRow != null) {
                for (int valuePos = 0; valuePos < this.valueProjection.length; ++valuePos) {
                    producedRow.setField(this.valueProjection[valuePos], physicalValueRow.getField(valuePos));
                }
            }
            for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
                producedRow.setField(this.physicalArity + metadataPos, this.metadataConverters[metadataPos].read(this.inputRecord));
            }
            this.outputCollector.collect((Object)producedRow);
        }
    }

    private static final class BufferingCollector
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<RowData> buffer = new ArrayList<RowData>();

        private BufferingCollector() {
        }

        public void collect(RowData record) {
            this.buffer.add(record);
        }

        public void close() {
        }
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(ConsumerRecord<?, ?> var1);
    }
}

