/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Header;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.table.BufferedUpsertSinkFunction;
import org.apache.flink.streaming.connectors.kafka.table.KafkaSinkSemantic;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.kafka.DynamicKafkaSerializationSchema;
import org.apache.inlong.sort.kafka.FlinkKafkaProducer;
import org.apache.inlong.sort.kafka.table.KafkaOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KafkaDynamicSink
implements DynamicTableSink,
SupportsWritingMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDynamicSink.class);
    private static final String VALUE_METADATA_PREFIX = "value.";
    protected final DataType physicalDataType;
    @Nullable
    protected final EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat;
    protected final EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat;
    protected final int[] keyProjection;
    protected final int[] valueProjection;
    @Nullable
    protected final String keyPrefix;
    protected final String topic;
    protected final Properties properties;
    @Nullable
    protected final FlinkKafkaPartitioner<RowData> partitioner;
    protected final KafkaSinkSemantic semantic;
    protected final boolean upsertMode;
    protected final SinkBufferFlushMode flushMode;
    @Nullable
    protected final Integer parallelism;
    private final CatalogTable catalogTable;
    private final String inLongMetric;
    private final String auditHostAndPorts;
    protected List<String> metadataKeys;
    protected DataType consumedDataType;

    public KafkaDynamicSink(DataType consumedDataType, DataType physicalDataType, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, String topic, Properties properties, CatalogTable table, @Nullable FlinkKafkaPartitioner<RowData> partitioner, KafkaSinkSemantic semantic, boolean upsertMode, SinkBufferFlushMode flushMode, @Nullable Integer parallelism, String inLongMetric, String auditHostAndPorts) {
        this.consumedDataType = (DataType)Preconditions.checkNotNull((Object)consumedDataType, (String)"Consumed data type must not be null.");
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"Physical data type must not be null.");
        this.keyEncodingFormat = keyEncodingFormat;
        this.valueEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(valueEncodingFormat, (String)"Value encoding format must not be null.");
        this.keyProjection = (int[])Preconditions.checkNotNull((Object)keyProjection, (String)"Key projection must not be null.");
        this.valueProjection = (int[])Preconditions.checkNotNull((Object)valueProjection, (String)"Value projection must not be null.");
        this.keyPrefix = keyPrefix;
        this.metadataKeys = Collections.emptyList();
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.catalogTable = table;
        this.partitioner = partitioner;
        this.semantic = (KafkaSinkSemantic)((Object)Preconditions.checkNotNull((Object)((Object)semantic), (String)"Semantic must not be null."));
        this.upsertMode = upsertMode;
        this.flushMode = (SinkBufferFlushMode)Preconditions.checkNotNull((Object)flushMode);
        if (flushMode.isEnabled() && !upsertMode) {
            throw new IllegalArgumentException("Sink buffer flush is only supported in upsert-kafka.");
        }
        this.parallelism = parallelism;
        this.inLongMetric = inLongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (((Boolean)Configuration.fromMap((Map)this.catalogTable.getOptions()).get(KafkaOptions.KAFKA_IGNORE_ALL_CHANGELOG)).booleanValue()) {
            LOG.warn("Kafka sink receive all changelog record. Regard any other record as insert-only record.");
            return ChangelogMode.all();
        }
        return this.valueEncodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema<RowData> keySerialization = this.createSerialization(context, this.keyEncodingFormat, this.keyProjection, this.keyPrefix);
        SerializationSchema<RowData> valueSerialization = this.createSerialization(context, this.valueEncodingFormat, this.valueProjection, null);
        FlinkKafkaProducer<RowData> kafkaProducer = this.createKafkaProducer(keySerialization, valueSerialization);
        if (this.flushMode.isEnabled() && this.upsertMode) {
            BufferedUpsertSinkFunction buffedSinkFunction = new BufferedUpsertSinkFunction((RichSinkFunction<RowData>)kafkaProducer, this.physicalDataType, this.keyProjection, (TypeInformation<RowData>)context.createTypeInformation(this.consumedDataType), this.flushMode);
            return SinkFunctionProvider.of((SinkFunction)buffedSinkFunction, (Integer)this.parallelism);
        }
        return SinkFunctionProvider.of(kafkaProducer, (Integer)this.parallelism);
    }

    public Map<String, DataType> listWritableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        this.valueEncodingFormat.listWritableMetadata().forEach((key, value) -> metadataMap.put(VALUE_METADATA_PREFIX + key, (DataType)value));
        Stream.of(WritableMetadata.values()).forEachOrdered(m -> metadataMap.put(m.key, m.dataType));
        return metadataMap;
    }

    public void applyWritableMetadata(List<String> metadataKeys, DataType consumedDataType) {
        List formatMetadataKeys = metadataKeys.stream().filter(k -> k.startsWith(VALUE_METADATA_PREFIX)).collect(Collectors.toList());
        ArrayList<String> connectorMetadataKeys = new ArrayList<String>(metadataKeys);
        connectorMetadataKeys.removeAll(formatMetadataKeys);
        Map formatMetadata = this.valueEncodingFormat.listWritableMetadata();
        if (formatMetadata.size() > 0) {
            List requestedFormatMetadataKeys = formatMetadataKeys.stream().map(k -> k.substring(VALUE_METADATA_PREFIX.length())).collect(Collectors.toList());
            this.valueEncodingFormat.applyWritableMetadata(requestedFormatMetadataKeys);
        }
        this.metadataKeys = connectorMetadataKeys;
        this.consumedDataType = consumedDataType;
    }

    public DynamicTableSink copy() {
        KafkaDynamicSink copy = new KafkaDynamicSink(this.consumedDataType, this.physicalDataType, this.keyEncodingFormat, this.valueEncodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.topic, this.properties, this.catalogTable, this.partitioner, this.semantic, this.upsertMode, this.flushMode, this.parallelism, this.inLongMetric, this.auditHostAndPorts);
        copy.metadataKeys = this.metadataKeys;
        return copy;
    }

    public String asSummaryString() {
        return "Kafka table sink";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaDynamicSink that = (KafkaDynamicSink)o;
        return Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.consumedDataType, that.consumedDataType) && Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.keyEncodingFormat, that.keyEncodingFormat) && Objects.equals(this.valueEncodingFormat, that.valueEncodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.keyPrefix, that.keyPrefix) && Objects.equals(this.topic, that.topic) && Objects.equals(this.properties, that.properties) && Objects.equals(this.partitioner, that.partitioner) && Objects.equals((Object)this.semantic, (Object)that.semantic) && Objects.equals(this.upsertMode, that.upsertMode) && Objects.equals(this.flushMode, that.flushMode) && Objects.equals(this.parallelism, that.parallelism) && Objects.equals(this.inLongMetric, that.inLongMetric) && Objects.equals(this.auditHostAndPorts, that.auditHostAndPorts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadataKeys, this.consumedDataType, this.physicalDataType, this.keyEncodingFormat, this.valueEncodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.topic, this.properties, this.partitioner, this.semantic, this.upsertMode, this.flushMode, this.parallelism, this.inLongMetric, this.auditHostAndPorts});
    }

    protected FlinkKafkaProducer<RowData> createKafkaProducer(SerializationSchema<RowData> keySerialization, SerializationSchema<RowData> valueSerialization) {
        List physicalChildren = this.physicalDataType.getLogicalType().getChildren();
        RowData.FieldGetter[] keyFieldGetters = (RowData.FieldGetter[])Arrays.stream(this.keyProjection).mapToObj(targetField -> RowData.createFieldGetter((LogicalType)((LogicalType)physicalChildren.get(targetField)), (int)targetField)).toArray(RowData.FieldGetter[]::new);
        RowData.FieldGetter[] valueFieldGetters = (RowData.FieldGetter[])Arrays.stream(this.valueProjection).mapToObj(targetField -> RowData.createFieldGetter((LogicalType)((LogicalType)physicalChildren.get(targetField)), (int)targetField)).toArray(RowData.FieldGetter[]::new);
        int[] metadataPositions = Stream.of(WritableMetadata.values()).mapToInt(m -> {
            int pos = this.metadataKeys.indexOf(m.key);
            if (pos < 0) {
                return -1;
            }
            return physicalChildren.size() + pos;
        }).toArray();
        boolean hasMetadata = this.metadataKeys.size() > 0;
        DynamicKafkaSerializationSchema kafkaSerializer = new DynamicKafkaSerializationSchema(this.topic, this.partitioner, keySerialization, valueSerialization, keyFieldGetters, valueFieldGetters, hasMetadata, metadataPositions, this.upsertMode);
        return new FlinkKafkaProducer<RowData>(this.topic, kafkaSerializer, this.properties, FlinkKafkaProducer.Semantic.valueOf(this.semantic.toString()), 5, this.inLongMetric, this.auditHostAndPorts);
    }

    @Nullable
    private SerializationSchema<RowData> createSerialization(DynamicTableSink.Context context, @Nullable EncodingFormat<SerializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow((DataType)this.physicalDataType, (int[])projection);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (SerializationSchema)format.createRuntimeEncoder(context, physicalFormatDataType);
    }

    private static class KafkaHeader
    implements Header {
        private final String key;
        private final byte[] value;

        KafkaHeader(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public byte[] value() {
            return this.value;
        }
    }

    static enum WritableMetadata {
        HEADERS("headers", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.BYTES().nullable())).nullable(), new DynamicKafkaSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                MapData map = row.getMap(pos);
                ArrayData keyArray = map.keyArray();
                ArrayData valueArray = map.valueArray();
                ArrayList<KafkaHeader> headers = new ArrayList<KafkaHeader>();
                for (int i = 0; i < keyArray.size(); ++i) {
                    if (keyArray.isNullAt(i) || valueArray.isNullAt(i)) continue;
                    String key = keyArray.getString(i).toString();
                    byte[] value = valueArray.getBinary(i);
                    headers.add(new KafkaHeader(key, value));
                }
                return headers;
            }
        }),
        TIMESTAMP("timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), new DynamicKafkaSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getTimestamp(pos, 3).getMillisecond();
            }
        });

        final String key;
        final DataType dataType;
        final DynamicKafkaSerializationSchema.MetadataConverter converter;

        private WritableMetadata(String key, DataType dataType, DynamicKafkaSerializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

