/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    public static <T> Map<String, T> translateDeprecatedConfigs(Map<String, T> configs, String[][] aliasGroups) {
        return ConfigUtils.translateDeprecatedConfigs(configs, Stream.of(aliasGroups).collect(Collectors.toMap(x -> x[0], x -> Stream.of(x).skip(1L).collect(Collectors.toList()))));
    }

    public static <T> Map<String, T> translateDeprecatedConfigs(Map<String, T> configs, Map<String, List<String>> aliasGroups) {
        Set aliasSet = Stream.concat(aliasGroups.keySet().stream(), aliasGroups.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
        Map<String, Object> newConfigs = configs.entrySet().stream().filter(e -> !aliasSet.contains(e.getKey())).filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        aliasGroups.forEach((target, aliases) -> {
            List deprecated = aliases.stream().filter(configs::containsKey).collect(Collectors.toList());
            if (deprecated.isEmpty()) {
                if (configs.containsKey(target)) {
                    newConfigs.put((String)target, configs.get(target));
                }
                return;
            }
            String aliasString = String.join((CharSequence)", ", deprecated);
            if (configs.containsKey(target)) {
                log.error(target + " was configured, as well as the deprecated alias(es) " + aliasString + ".  Using the value of " + target);
                newConfigs.put((String)target, configs.get(target));
            } else if (deprecated.size() > 1) {
                log.error("The configuration keys " + aliasString + " are deprecated and may be removed in the future.  Additionally, this configuration is ambigous because these configuration keys are all aliases for " + target + ".  Please update your configuration to have only " + target + " set.");
                newConfigs.put((String)target, configs.get(deprecated.get(0)));
            } else {
                log.warn("Configuration key " + (String)deprecated.get(0) + " is deprecated and may be removed in the future.  Please update your configuration to use " + target + " instead.");
                newConfigs.put((String)target, configs.get(deprecated.get(0)));
            }
        });
        return newConfigs;
    }
}

