/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeQuorumResponse;

public class DescribeQuorumRequest
extends AbstractRequest {
    public final DescribeQuorumRequestData data;

    private DescribeQuorumRequest(DescribeQuorumRequestData data, short version) {
        super(ApiKeys.DESCRIBE_QUORUM, version);
        this.data = data;
    }

    public DescribeQuorumRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_QUORUM, version);
        this.data = new DescribeQuorumRequestData(struct, version);
    }

    public DescribeQuorumRequest(DescribeQuorumRequestData data) {
        this(data, (short)(DescribeQuorumRequestData.SCHEMAS.length - 1));
    }

    public static DescribeQuorumRequestData singletonRequest(TopicPartition topicPartition) {
        return new DescribeQuorumRequestData().setTopics(Collections.singletonList(new DescribeQuorumRequestData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new DescribeQuorumRequestData.PartitionData().setPartitionIndex(topicPartition.partition())))));
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeQuorumResponse(DescribeQuorumRequest.getTopLevelErrorResponse(Errors.forException(e)));
    }

    public static DescribeQuorumResponseData getPartitionLevelErrorResponse(DescribeQuorumRequestData data, Errors error) {
        short errorCode = error.code();
        ArrayList<DescribeQuorumResponseData.TopicData> topicResponses = new ArrayList<DescribeQuorumResponseData.TopicData>();
        for (DescribeQuorumRequestData.TopicData topic : data.topics()) {
            topicResponses.add(new DescribeQuorumResponseData.TopicData().setTopicName(topic.topicName()).setPartitions(topic.partitions().stream().map(requestPartition -> new DescribeQuorumResponseData.PartitionData().setPartitionIndex(requestPartition.partitionIndex()).setErrorCode(errorCode)).collect(Collectors.toList())));
        }
        return new DescribeQuorumResponseData().setTopics(topicResponses);
    }

    public static DescribeQuorumResponseData getTopLevelErrorResponse(Errors topLevelError) {
        return new DescribeQuorumResponseData().setErrorCode(topLevelError.code());
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeQuorumRequest> {
        private final DescribeQuorumRequestData data;

        public Builder(DescribeQuorumRequestData data) {
            super(ApiKeys.DESCRIBE_QUORUM);
            this.data = data;
        }

        @Override
        public DescribeQuorumRequest build(short version) {
            return new DescribeQuorumRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

