/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriberUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicListSubscriber
implements KafkaSubscriber {
    private static final long serialVersionUID = -6917603843104947866L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicListSubscriber.class);
    private final List<String> topics;

    TopicListSubscriber(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public KafkaSubscriber.PartitionChange getPartitionChanges(AdminClient adminClient, Set<TopicPartition> currentAssignment) {
        Map<String, TopicDescription> topicMetadata;
        HashSet<TopicPartition> newPartitions = new HashSet<TopicPartition>();
        HashSet<TopicPartition> removedPartitions = new HashSet<TopicPartition>(currentAssignment);
        try {
            topicMetadata = adminClient.describeTopics(this.topics).all().get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get topic metadata.", e);
        }
        this.topics.forEach(topic -> {
            List<TopicPartitionInfo> partitions = ((TopicDescription)topicMetadata.get(topic)).partitions();
            if (partitions != null) {
                KafkaSubscriberUtils.updatePartitionChanges(topic, newPartitions, removedPartitions, partitions);
            }
        });
        KafkaSubscriberUtils.maybeLog(newPartitions, removedPartitions, LOG);
        return new KafkaSubscriber.PartitionChange(newPartitions, removedPartitions);
    }
}

