/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import io.debezium.time.Conversions;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.util.Date;

public class ZonedTime {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_TIME;
    public static final String SCHEMA_NAME = "io.debezium.time.ZonedTime";

    public static SchemaBuilder builder() {
        return SchemaBuilder.string().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return ZonedTime.builder().build();
    }

    public static String toIsoString(Object value, ZoneId defaultZone, TemporalAdjuster adjuster) {
        if (value instanceof OffsetTime) {
            return ZonedTime.toIsoString((OffsetTime)value, adjuster);
        }
        if (value instanceof OffsetDateTime) {
            return ZonedTime.toIsoString((OffsetDateTime)value, adjuster);
        }
        if (value instanceof Date) {
            return ZonedTime.toIsoString((Date)value, defaultZone, adjuster);
        }
        throw new IllegalArgumentException("Unable to convert to OffsetTime from unexpected value '" + value + "' of type " + value.getClass().getName());
    }

    public static String toIsoString(OffsetDateTime timestamp, TemporalAdjuster adjuster) {
        if (adjuster != null) {
            timestamp = timestamp.with(adjuster);
        }
        return timestamp.toOffsetTime().format(FORMATTER);
    }

    public static String toIsoString(OffsetTime timestamp, TemporalAdjuster adjuster) {
        if (adjuster != null) {
            timestamp = timestamp.with(adjuster);
        }
        return timestamp.format(FORMATTER);
    }

    public static String toIsoString(Date timestamp, ZoneId zoneId, TemporalAdjuster adjuster) {
        if (timestamp instanceof Timestamp) {
            return ZonedTime.toIsoString((Timestamp)timestamp, zoneId, adjuster);
        }
        if (timestamp instanceof java.sql.Date) {
            return ZonedTime.toIsoString((java.sql.Date)timestamp, zoneId, adjuster);
        }
        if (timestamp instanceof Time) {
            return ZonedTime.toIsoString((Time)timestamp, zoneId, adjuster);
        }
        return timestamp.toInstant().atZone(zoneId).format(FORMATTER);
    }

    public static String toIsoString(Timestamp timestamp, ZoneId zoneId, TemporalAdjuster adjuster) {
        ZonedDateTime zdt = timestamp.toInstant().atZone(zoneId);
        if (adjuster != null) {
            zdt = zdt.with(adjuster);
        }
        return zdt.format(FORMATTER);
    }

    public static String toIsoString(java.sql.Date date, ZoneId zoneId, TemporalAdjuster adjuster) {
        LocalDate localDate = date.toLocalDate();
        if (adjuster != null) {
            localDate = localDate.with(adjuster);
        }
        ZonedDateTime zdt = ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, zoneId);
        return zdt.format(FORMATTER);
    }

    public static String toIsoString(Time time, ZoneId zoneId, TemporalAdjuster adjuster) {
        LocalTime localTime = time.toLocalTime();
        if (adjuster != null) {
            localTime = localTime.with(adjuster);
        }
        ZonedDateTime zdt = ZonedDateTime.of(Conversions.EPOCH, localTime, zoneId);
        return zdt.format(FORMATTER);
    }

    private ZonedTime() {
    }
}

