/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.tools;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Metric;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.MetricName;
import java.util.Map;
import java.util.TreeMap;

public class ToolsUtils {
    public static void printMetrics(Map<MetricName, ? extends Metric> metrics) {
        if (metrics != null && !metrics.isEmpty()) {
            int maxLengthOfDisplayName = 0;
            TreeMap<String, Object> sortedMetrics = new TreeMap<String, Object>();
            for (Metric metric : metrics.values()) {
                MetricName mName = metric.metricName();
                String mergedName = mName.group() + ":" + mName.name() + ":" + mName.tags();
                maxLengthOfDisplayName = maxLengthOfDisplayName < mergedName.length() ? mergedName.length() : maxLengthOfDisplayName;
                sortedMetrics.put(mergedName, metric.metricValue());
            }
            String doubleOutputFormat = "%-" + maxLengthOfDisplayName + "s : %.3f";
            String string = "%-" + maxLengthOfDisplayName + "s : %s";
            System.out.println(String.format("\n%-" + maxLengthOfDisplayName + "s   %s", "Metric Name", "Value"));
            for (Map.Entry entry : sortedMetrics.entrySet()) {
                String outputFormat = entry.getValue() instanceof Double ? doubleOutputFormat : string;
                System.out.println(String.format(outputFormat, entry.getKey(), entry.getValue()));
            }
        }
    }
}

