/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BeginQuorumEpochResponse
extends AbstractResponse {
    public final BeginQuorumEpochResponseData data;

    public BeginQuorumEpochResponse(BeginQuorumEpochResponseData data) {
        this.data = data;
    }

    public BeginQuorumEpochResponse(Struct struct, short version) {
        this.data = new BeginQuorumEpochResponseData(struct, version);
    }

    public BeginQuorumEpochResponse(Struct struct) {
        short latestVersion = (short)(BeginQuorumEpochResponseData.SCHEMAS.length - 1);
        this.data = new BeginQuorumEpochResponseData(struct, latestVersion);
    }

    public static BeginQuorumEpochResponseData singletonResponse(Errors topLevelError, TopicPartition topicPartition, Errors partitionLevelError, int leaderEpoch, int leaderId) {
        return new BeginQuorumEpochResponseData().setErrorCode(topLevelError.code()).setTopics(Collections.singletonList(new BeginQuorumEpochResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new BeginQuorumEpochResponseData.PartitionData().setErrorCode(partitionLevelError.code()).setLeaderId(leaderId).setLeaderEpoch(leaderEpoch)))));
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        Errors topLevelError = Errors.forCode(this.data.errorCode());
        if (topLevelError != Errors.NONE) {
            errors.put(topLevelError, 1);
        }
        for (BeginQuorumEpochResponseData.TopicData topicResponse : this.data.topics()) {
            for (BeginQuorumEpochResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                errors.compute(Errors.forCode(partitionResponse.errorCode()), (error, count) -> count == null ? 1 : count + 1);
            }
        }
        return errors;
    }

    public static BeginQuorumEpochResponse parse(ByteBuffer buffer, short version) {
        return new BeginQuorumEpochResponse(ApiKeys.BEGIN_QUORUM_EPOCH.responseSchema(version).read(buffer), version);
    }
}

