/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketException;
import java.security.Security;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.SSLDefaultTrustManager;

public class SSLIRCConnection
extends IRCConnection {
    private Vector trustManagers = new Vector(1);

    public SSLIRCConnection(String host, int[] ports, String pass, String nick, String username, String realname) {
        super(host, ports, pass, nick, username, realname);
    }

    public SSLIRCConnection(String host, int portMin, int portMax, String pass, String nick, String username, String realname) {
        super(host, portMin, portMax, pass, nick, username, realname);
    }

    public void connect() throws IOException {
        if (this.level != 0) {
            throw new SocketException("Socket closed or already open (" + this.level + ")");
        }
        IOException exception = null;
        SSLSocketFactory sf = null;
        Socket s2 = null;
        int i = 0;
        while (i < this.ports.length && s2 == null) {
            try {
                if (sf == null) {
                    sf = this.getSocketFactory();
                }
                s2 = (SSLSocket)sf.createSocket(this.host, this.ports[i]);
                ((SSLSocket)s2).startHandshake();
                exception = null;
            }
            catch (IOException exc) {
                if (s2 != null) {
                    s2.close();
                }
                s2 = null;
                exception = exc;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        this.prepare(s2);
    }

    private SSLSocketFactory getSocketFactory() throws SSLException {
        if (this.trustManagers.size() == 0) {
            this.addTrustManager((TrustManager)new SSLDefaultTrustManager());
        }
        try {
            Security.addProvider((java.security.Provider)new Provider());
            SSLContext context = SSLContext.getInstance((String)"SSL");
            context.init(null, this.getTrustManagers(), null);
            SSLSocketFactory socketFactory = context.getSocketFactory();
            return socketFactory;
        }
        catch (Exception exc) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exc.printStackTrace(pw);
            pw.close();
            throw new SSLException("Exception while preparing the SSLSocket:\n---\n" + sw.toString() + "---");
        }
    }

    public void addTrustManager(TrustManager trustManager) {
        this.trustManagers.add(trustManager);
    }

    public boolean removeTrustManager(TrustManager trustManager) {
        return this.trustManagers.remove(trustManager);
    }

    public TrustManager[] getTrustManagers() {
        Object[] tm = new TrustManager[this.trustManagers.size()];
        this.trustManagers.copyInto(tm);
        return tm;
    }
}

