/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.zookeeper.server.admin.CommandOutputter;
import org.apache.zookeeper.server.admin.CommandResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOutputter
implements CommandOutputter {
    static final Logger LOG = LoggerFactory.getLogger(JsonOutputter.class);
    public static final String ERROR_RESPONSE = "{\"error\": \"Exception writing command response to JSON\"}";
    private ObjectMapper mapper = new ObjectMapper();

    public JsonOutputter() {
        this.mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public void output(CommandResponse response, PrintWriter pw) {
        try {
            this.mapper.writeValue(pw, response.toMap());
        }
        catch (JsonGenerationException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
        catch (JsonMappingException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
        catch (IOException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
    }
}

