/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.flink.elasticsearch6.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class SetPublicFieldExecutor
extends SetExecutor {
    private final Introspector introspector;
    private Field field = null;

    public SetPublicFieldExecutor(Logger log, Introspector introspector, Class<?> clazz, String property, Object arg) {
        this.log = log;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty(property)) {
            this.discover(clazz, property, arg);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getField() != null;
    }

    public Field getField() {
        return this.field;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class<?> clazz, String property, Object arg) {
        try {
            Field field = this.introspector.getField(clazz, property);
            if (!Modifier.isFinal(field.getModifiers())) {
                this.setField(field);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception while looking for public field '" + property;
            this.log.error(msg, e);
            throw new VelocityException(msg, e);
        }
    }

    @Override
    public Object execute(Object o, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.isAlive()) {
            Object oldValue = this.getField().get(o);
            this.getField().set(o, value);
            return oldValue;
        }
        return null;
    }
}

