/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.elasticsearch.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.DocWriteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.elasticsearch.ElasticsearchSinkFunction;
import org.apache.inlong.sort.elasticsearch.table.IndexGenerator;
import org.apache.inlong.sort.elasticsearch.table.RequestFactory;

public class RowElasticsearchSinkFunction
implements ElasticsearchSinkFunction<RowData> {
    private static final long serialVersionUID = 1L;
    private final IndexGenerator indexGenerator;
    private final String docType;
    private final SerializationSchema<RowData> serializationSchema;
    private final XContentType contentType;
    private final RequestFactory requestFactory;
    private final Function<RowData, String> createKey;
    private final String inLongMetric;
    private final String auditHostAndPorts;
    private final Function<RowData, String> createRouting;
    private transient RuntimeContext runtimeContext;
    private SinkMetricData sinkMetricData;
    private Long dataSize = 0L;
    private Long rowSize = 0L;
    private String groupId;
    private String streamId;
    private transient AuditImp auditImp;

    public RowElasticsearchSinkFunction(IndexGenerator indexGenerator, @Nullable String docType, SerializationSchema<RowData> serializationSchema, XContentType contentType, RequestFactory requestFactory, Function<RowData, String> createKey, @Nullable Function<RowData, String> createRouting, String inLongMetric, String auditHostAndPorts) {
        this.indexGenerator = (IndexGenerator)Preconditions.checkNotNull((Object)indexGenerator);
        this.docType = docType;
        this.serializationSchema = (SerializationSchema)Preconditions.checkNotNull(serializationSchema);
        this.contentType = (XContentType)((Object)Preconditions.checkNotNull((Object)((Object)contentType)));
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
        this.createKey = (Function)Preconditions.checkNotNull(createKey);
        this.createRouting = createRouting;
        this.inLongMetric = inLongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
    }

    @Override
    public void open(RuntimeContext ctx) {
        this.indexGenerator.open();
        this.runtimeContext = ctx;
        if (this.inLongMetric != null && !this.inLongMetric.isEmpty()) {
            String[] inLongMetricArray = this.inLongMetric.split("&");
            this.groupId = inLongMetricArray[0];
            this.streamId = inLongMetricArray[1];
            String nodeId = inLongMetricArray[2];
            this.sinkMetricData = new SinkMetricData(this.groupId, this.streamId, nodeId, this.runtimeContext.getMetricGroup());
            this.sinkMetricData.registerMetricsForDirtyBytes();
            this.sinkMetricData.registerMetricsForDirtyRecords();
            this.sinkMetricData.registerMetricsForNumBytesOut();
            this.sinkMetricData.registerMetricsForNumRecordsOut();
            this.sinkMetricData.registerMetricsForNumBytesOutPerSecond();
            this.sinkMetricData.registerMetricsForNumRecordsOutPerSecond();
        }
        if (this.auditHostAndPorts != null) {
            AuditImp.getInstance().setAuditProxy(new HashSet<String>(Arrays.asList(this.auditHostAndPorts.split("&"))));
            this.auditImp = AuditImp.getInstance();
        }
    }

    private void outputMetricForAudit(long size) {
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_OUTPUT, this.groupId, this.streamId, System.currentTimeMillis(), 1L, size);
        }
    }

    private void sendMetrics(byte[] document) {
        if (this.sinkMetricData.getNumBytesOut() != null) {
            this.sinkMetricData.getNumBytesOut().inc((long)document.length);
        }
        this.outputMetricForAudit(document.length);
    }

    @Override
    public void process(RowData element, RuntimeContext ctx, RequestIndexer indexer) {
        switch (element.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                this.processUpsert(element, indexer);
                break;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                this.processDelete(element, indexer);
                break;
            }
            default: {
                throw new TableException("Unsupported message kind: " + element.getRowKind());
            }
        }
    }

    private void processUpsert(RowData row, RequestIndexer indexer) {
        byte[] document = this.serializationSchema.serialize((Object)row);
        String key = this.createKey.apply(row);
        this.sendMetrics(document);
        if (key != null) {
            UpdateRequest updateRequest = this.requestFactory.createUpdateRequest(this.indexGenerator.generate(row), this.docType, key, this.contentType, document);
            this.addRouting(updateRequest, row);
            indexer.add(updateRequest);
        } else {
            IndexRequest indexRequest = this.requestFactory.createIndexRequest(this.indexGenerator.generate(row), this.docType, key, this.contentType, document);
            this.addRouting(indexRequest, row);
            indexer.add(indexRequest);
        }
    }

    private void processDelete(RowData row, RequestIndexer indexer) {
        byte[] document = this.serializationSchema.serialize((Object)row);
        this.sendMetrics(document);
        String key = this.createKey.apply(row);
        DeleteRequest deleteRequest = this.requestFactory.createDeleteRequest(this.indexGenerator.generate(row), this.docType, key);
        this.addRouting(deleteRequest, row);
        indexer.add(deleteRequest);
    }

    private void addRouting(DocWriteRequest<?> request, RowData row) {
        if (null != this.createRouting) {
            String routing = this.createRouting.apply(row);
            request.routing(routing);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowElasticsearchSinkFunction that = (RowElasticsearchSinkFunction)o;
        return Objects.equals(this.indexGenerator, that.indexGenerator) && Objects.equals(this.docType, that.docType) && Objects.equals(this.serializationSchema, that.serializationSchema) && this.contentType == that.contentType && Objects.equals(this.requestFactory, that.requestFactory) && Objects.equals(this.createKey, that.createKey) && Objects.equals(this.inLongMetric, that.inLongMetric);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexGenerator, this.docType, this.serializationSchema, this.contentType, this.requestFactory, this.createKey, this.inLongMetric});
    }
}

