/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.elasticsearch.table;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class RoutingExtractor {
    private RoutingExtractor() {
    }

    public static Function<RowData, String> createRoutingExtractor(TableSchema schema, @Nullable String filedName) {
        if (filedName == null) {
            return null;
        }
        List tableColumns = schema.getTableColumns();
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            TableColumn column = (TableColumn)tableColumns.get(i);
            if (!column.getName().equals(filedName)) continue;
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)column.getType().getLogicalType(), (int)i);
            return (Function<RowData, String> & Serializable)row -> {
                Object fieldOrNull = fieldGetter.getFieldOrNull(row);
                if (fieldOrNull != null) {
                    return fieldOrNull.toString();
                }
                return null;
            };
        }
        throw new IllegalArgumentException("Filed " + filedName + " not exist in table schema.");
    }
}

