/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Strings;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventHelper;
import org.apache.flume.sink.AbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(LoggerSink.class);
    public static final int DEFAULT_MAX_BYTE_DUMP = 16;
    private int maxBytesToLog = 16;
    public static final String MAX_BYTES_DUMP_KEY = "maxBytesToLog";

    @Override
    public void configure(Context context) {
        String strMaxBytes = context.getString(MAX_BYTES_DUMP_KEY);
        if (!Strings.isNullOrEmpty(strMaxBytes)) {
            try {
                this.maxBytesToLog = Integer.parseInt(strMaxBytes);
            }
            catch (NumberFormatException e) {
                logger.warn(String.format("Unable to convert %s to integer, using default value(%d) for maxByteToDump", strMaxBytes, 16));
                this.maxBytesToLog = 16;
            }
        }
    }

    @Override
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status result = Sink.Status.READY;
        Channel channel = this.getChannel();
        Event event = null;
        try (Transaction transaction = channel.getTransaction();){
            transaction.begin();
            event = channel.take();
            if (event != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Event: " + EventHelper.dumpEvent(event, this.maxBytesToLog));
                }
            } else {
                result = Sink.Status.BACKOFF;
            }
            transaction.commit();
        }
        return result;
    }
}

