/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Preconditions;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvVarResolverProperties
extends Properties {
    protected static String resolveEnvVars(String input) {
        Preconditions.checkNotNull(input);
        Pattern p = Pattern.compile("\\$\\{(\\w+)\\}");
        Matcher m3 = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            String envVarName = m3.group(1);
            String envVarValue = System.getenv(envVarName);
            m3.appendReplacement(sb, null == envVarValue ? "" : envVarValue);
        }
        m3.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String getProperty(String key) {
        return EnvVarResolverProperties.resolveEnvVars(super.getProperty(key));
    }
}

