/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.file.Commit;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.Put;
import org.apache.flume.channel.file.Rollback;
import org.apache.flume.channel.file.Take;
import org.apache.flume.channel.file.Writable;
import org.apache.flume.channel.file.proto.ProtosFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TransactionEventRecord
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionEventRecord.class);
    private final long transactionID;
    private long logWriteOrderID;
    static final int MAGIC_HEADER = -559038737;
    private static final ImmutableMap<Short, Constructor<? extends TransactionEventRecord>> TYPES;

    protected TransactionEventRecord(long transactionID, long logWriteOrderID) {
        this.transactionID = transactionID;
        this.logWriteOrderID = logWriteOrderID;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    abstract void writeProtos(OutputStream var1) throws IOException;

    abstract void readProtos(InputStream var1) throws IOException, CorruptEventException;

    long getLogWriteOrderID() {
        return this.logWriteOrderID;
    }

    long getTransactionID() {
        return this.transactionID;
    }

    abstract short getRecordType();

    @Deprecated
    static ByteBuffer toByteBufferV2(TransactionEventRecord record) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(512);
        DataOutputStream dataOutput = new DataOutputStream(byteOutput);
        try {
            dataOutput.writeInt(-559038737);
            dataOutput.writeShort(record.getRecordType());
            dataOutput.writeLong(record.getTransactionID());
            dataOutput.writeLong(record.getLogWriteOrderID());
            record.write(dataOutput);
            dataOutput.flush();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteOutput.toByteArray());
            return byteBuffer;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        finally {
            if (dataOutput != null) {
                try {
                    dataOutput.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing byte array output stream", e);
                }
            }
        }
    }

    @Deprecated
    static TransactionEventRecord fromDataInputV2(DataInput in) throws IOException {
        int header = in.readInt();
        if (header != -559038737) {
            throw new IOException("Header " + Integer.toHexString(header) + " is not the required value: " + Integer.toHexString(-559038737));
        }
        short type = in.readShort();
        long transactionID = in.readLong();
        long writeOrderID = in.readLong();
        TransactionEventRecord entry = TransactionEventRecord.newRecordForType(type, transactionID, writeOrderID);
        entry.readFields(in);
        return entry;
    }

    static ByteBuffer toByteBuffer(TransactionEventRecord record) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(512);
        try {
            ProtosFactory.TransactionEventHeader.Builder headerBuilder = ProtosFactory.TransactionEventHeader.newBuilder();
            headerBuilder.setType(record.getRecordType());
            headerBuilder.setTransactionID(record.getTransactionID());
            headerBuilder.setWriteOrderID(record.getLogWriteOrderID());
            headerBuilder.build().writeDelimitedTo(byteOutput);
            record.writeProtos(byteOutput);
            ProtosFactory.TransactionEventFooter footer = ProtosFactory.TransactionEventFooter.newBuilder().build();
            footer.writeDelimitedTo(byteOutput);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteOutput.toByteArray());
            return byteBuffer;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        finally {
            if (byteOutput != null) {
                try {
                    byteOutput.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing byte array output stream", e);
                }
            }
        }
    }

    static TransactionEventRecord fromByteArray(byte[] buffer) throws IOException, CorruptEventException {
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        try {
            ProtosFactory.TransactionEventHeader header = Preconditions.checkNotNull(ProtosFactory.TransactionEventHeader.parseDelimitedFrom(in), "Header cannot be null");
            short type = (short)header.getType();
            long transactionID = header.getTransactionID();
            long writeOrderID = header.getWriteOrderID();
            TransactionEventRecord transactionEvent = TransactionEventRecord.newRecordForType(type, transactionID, writeOrderID);
            transactionEvent.readProtos(in);
            ProtosFactory.TransactionEventFooter footer = Preconditions.checkNotNull(ProtosFactory.TransactionEventFooter.parseDelimitedFrom(in), "Footer cannot be null");
            TransactionEventRecord transactionEventRecord = transactionEvent;
            return transactionEventRecord;
        }
        catch (InvalidProtocolBufferException ex) {
            throw new CorruptEventException("Could not parse event from data file.", ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing byte array input stream", e);
            }
        }
    }

    static String getName(short type) {
        Constructor<? extends TransactionEventRecord> constructor = TYPES.get(type);
        Preconditions.checkNotNull(constructor, "Unknown action " + Integer.toHexString(type));
        return constructor.getDeclaringClass().getSimpleName();
    }

    private static TransactionEventRecord newRecordForType(short type, long transactionID, long writeOrderID) {
        Constructor<? extends TransactionEventRecord> constructor = TYPES.get(type);
        Preconditions.checkNotNull(constructor, "Unknown action " + Integer.toHexString(type));
        try {
            return constructor.newInstance(transactionID, writeOrderID);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            builder.put(Type.PUT.get(), Put.class.getDeclaredConstructor(Long.class, Long.class));
            builder.put(Type.TAKE.get(), Take.class.getDeclaredConstructor(Long.class, Long.class));
            builder.put(Type.ROLLBACK.get(), Rollback.class.getDeclaredConstructor(Long.class, Long.class));
            builder.put(Type.COMMIT.get(), Commit.class.getDeclaredConstructor(Long.class, Long.class));
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
        TYPES = builder.build();
    }

    static enum Type {
        PUT(1),
        TAKE(2),
        ROLLBACK(3),
        COMMIT(4);

        private short id;

        private Type(short id) {
            this.id = id;
        }

        public short get() {
            return this.id;
        }
    }
}

