/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import org.apache.flume.ChannelException;
import org.apache.flume.Event;
import org.apache.flume.Transaction;

public abstract class BasicTransactionSemantics
implements Transaction {
    private State state = State.NEW;
    private long initialThreadId = Thread.currentThread().getId();

    protected void doBegin() throws InterruptedException {
    }

    protected abstract void doPut(Event var1) throws InterruptedException;

    protected abstract Event doTake() throws InterruptedException;

    protected abstract void doCommit() throws InterruptedException;

    protected abstract void doRollback() throws InterruptedException;

    protected void doClose() {
    }

    protected BasicTransactionSemantics() {
    }

    protected void put(Event event) {
        Preconditions.checkState(Thread.currentThread().getId() == this.initialThreadId, "put() called from different thread than getTransaction()!");
        Preconditions.checkState(this.state.equals((Object)State.OPEN), "put() called when transaction is %s!", new Object[]{this.state});
        Preconditions.checkArgument(event != null, "put() called with null event!");
        try {
            this.doPut(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ChannelException(e.toString(), e);
        }
    }

    protected Event take() {
        Preconditions.checkState(Thread.currentThread().getId() == this.initialThreadId, "take() called from different thread than getTransaction()!");
        Preconditions.checkState(this.state.equals((Object)State.OPEN), "take() called when transaction is %s!", new Object[]{this.state});
        try {
            return this.doTake();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected State getState() {
        return this.state;
    }

    @Override
    public void begin() {
        Preconditions.checkState(Thread.currentThread().getId() == this.initialThreadId, "begin() called from different thread than getTransaction()!");
        Preconditions.checkState(this.state.equals((Object)State.NEW), "begin() called when transaction is " + (Object)((Object)this.state) + "!");
        try {
            this.doBegin();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ChannelException(e.toString(), e);
        }
        this.state = State.OPEN;
    }

    @Override
    public void commit() {
        Preconditions.checkState(Thread.currentThread().getId() == this.initialThreadId, "commit() called from different thread than getTransaction()!");
        Preconditions.checkState(this.state.equals((Object)State.OPEN), "commit() called when transaction is %s!", new Object[]{this.state});
        try {
            this.doCommit();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ChannelException(e.toString(), e);
        }
        this.state = State.COMPLETED;
    }

    @Override
    public void rollback() {
        Preconditions.checkState(Thread.currentThread().getId() == this.initialThreadId, "rollback() called from different thread than getTransaction()!");
        Preconditions.checkState(this.state.equals((Object)State.OPEN), "rollback() called when transaction is %s!", new Object[]{this.state});
        this.state = State.COMPLETED;
        try {
            this.doRollback();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ChannelException(e.toString(), e);
        }
    }

    @Override
    public void close() {
        Preconditions.checkState(Thread.currentThread().getId() == this.initialThreadId, "close() called from different thread than getTransaction()!");
        Preconditions.checkState(this.state.equals((Object)State.NEW) || this.state.equals((Object)State.COMPLETED), "close() called when transaction is %s - you must either commit or rollback first", new Object[]{this.state});
        this.state = State.CLOSED;
        this.doClose();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicTransactionSemantics: {");
        builder.append(" state:").append((Object)this.state);
        builder.append(" initialThreadId:").append(this.initialThreadId);
        builder.append(" }");
        return builder.toString();
    }

    protected static enum State {
        NEW,
        OPEN,
        COMPLETED,
        CLOSED;

    }
}

