/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flume.CounterGroup;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkRunner
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(SinkRunner.class);
    private static final long backoffSleepIncrement = 1000L;
    private static final long maxBackoffSleep = 5000L;
    private CounterGroup counterGroup = new CounterGroup();
    private PollingRunner runner;
    private Thread runnerThread;
    private LifecycleState lifecycleState = LifecycleState.IDLE;
    private SinkProcessor policy;

    public SinkRunner() {
    }

    public SinkRunner(SinkProcessor policy) {
        this();
        this.setSink(policy);
    }

    public SinkProcessor getPolicy() {
        return this.policy;
    }

    public void setSink(SinkProcessor policy) {
        this.policy = policy;
    }

    @Override
    public void start() {
        SinkProcessor policy = this.getPolicy();
        policy.start();
        this.runner = new PollingRunner();
        this.runner.policy = policy;
        this.runner.counterGroup = this.counterGroup;
        this.runner.shouldStop = new AtomicBoolean();
        this.runnerThread = new Thread(this.runner);
        this.runnerThread.setName("SinkRunner-PollingRunner-" + policy.getClass().getSimpleName());
        this.runnerThread.start();
        this.lifecycleState = LifecycleState.START;
    }

    @Override
    public void stop() {
        if (this.runnerThread != null) {
            this.runner.shouldStop.set(true);
            this.runnerThread.interrupt();
            while (this.runnerThread.isAlive()) {
                try {
                    logger.debug("Waiting for runner thread to exit");
                    this.runnerThread.join(500L);
                }
                catch (InterruptedException e) {
                    logger.debug("Interrupted while waiting for runner thread to exit. Exception follows.", e);
                }
            }
        }
        this.getPolicy().stop();
        this.lifecycleState = LifecycleState.STOP;
    }

    public String toString() {
        return "SinkRunner: { policy:" + this.getPolicy() + " counterGroup:" + this.counterGroup + " }";
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class PollingRunner
    implements Runnable {
        private SinkProcessor policy;
        private AtomicBoolean shouldStop;
        private CounterGroup counterGroup;

        @Override
        public void run() {
            logger.debug("Polling sink runner starting");
            while (!this.shouldStop.get()) {
                try {
                    if (this.policy.process().equals((Object)Sink.Status.BACKOFF)) {
                        this.counterGroup.incrementAndGet("runner.backoffs");
                        Thread.sleep(Math.min(this.counterGroup.incrementAndGet("runner.backoffs.consecutive") * 1000L, 5000L));
                        continue;
                    }
                    this.counterGroup.set("runner.backoffs.consecutive", 0L);
                }
                catch (InterruptedException e) {
                    logger.debug("Interrupted while processing an event. Exiting.");
                    this.counterGroup.incrementAndGet("runner.interruptions");
                }
                catch (Exception e) {
                    logger.error("Unable to deliver event. Exception follows.", e);
                    if (e instanceof EventDeliveryException) {
                        this.counterGroup.incrementAndGet("runner.deliveryErrors");
                    } else {
                        this.counterGroup.incrementAndGet("runner.errors");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            logger.debug("Polling runner exiting. Metrics:{}", (Object)this.counterGroup);
        }
    }
}

