/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Context {
    private Map<String, String> parameters = Collections.synchronizedMap(new HashMap());

    public Context() {
    }

    public Context(Map<String, String> paramters) {
        this();
        this.putAll(paramters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableMap<String, String> getParameters() {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return ImmutableMap.copyOf(this.parameters);
        }
    }

    public void clear() {
        this.parameters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableMap<String, String> getSubProperties(String prefix) {
        Preconditions.checkArgument(prefix.endsWith("."), "The given prefix does not end with a period (" + prefix + ")");
        HashMap<String, String> result = Maps.newHashMap();
        Map<String, String> map = this.parameters;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                String name = key.substring(prefix.length());
                result.put(name, entry.getValue());
            }
        }
        return ImmutableMap.copyOf(result);
    }

    public void putAll(Map<String, String> map) {
        this.parameters.putAll(map);
    }

    public void put(String key, String value) {
        this.parameters.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, defaultValue);
    }

    public String getString(String key) {
        return this.get(key);
    }

    public Float getFloat(String key, Float defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Float.valueOf(Float.parseFloat(value.trim()));
        }
        return defaultValue;
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Double getDouble(String key, Double defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Double.parseDouble(value.trim());
        }
        return defaultValue;
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    private String get(String key, String defaultValue) {
        String result = this.parameters.get(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    private String get(String key) {
        return this.get(key, null);
    }

    public String toString() {
        return "{ parameters:" + this.parameters + " }";
    }
}

