/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.NotifyOnceListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedSupplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.metrics.MeanMetric;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.network.CloseableChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.OutboundMessage;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TcpChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

final class OutboundHandler {
    private static final Logger logger = LogManager.getLogger(OutboundHandler.class);
    private final MeanMetric transmittedBytesMetric = new MeanMetric();
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private final TransportLogger transportLogger;

    OutboundHandler(ThreadPool threadPool, BigArrays bigArrays, TransportLogger transportLogger) {
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
        this.transportLogger = transportLogger;
    }

    void sendBytes(TcpChannel channel, BytesReference bytes, ActionListener<Void> listener) {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        SendContext sendContext = new SendContext(channel, () -> bytes, (ActionListener)listener);
        try {
            this.internalSendMessage(channel, sendContext);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    void sendMessage(TcpChannel channel, OutboundMessage networkMessage, ActionListener<Void> listener) throws IOException {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        MessageSerializer serializer = new MessageSerializer(networkMessage, this.bigArrays);
        SendContext sendContext = new SendContext(channel, serializer, listener, serializer);
        this.internalSendMessage(channel, sendContext);
    }

    private void internalSendMessage(TcpChannel channel, SendContext sendContext) throws IOException {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        BytesReference reference = sendContext.get();
        try {
            channel.sendMessage(reference, sendContext);
        }
        catch (RuntimeException ex) {
            sendContext.onFailure(ex);
            CloseableChannel.closeChannel(channel);
            throw ex;
        }
    }

    MeanMetric getTransmittedBytes() {
        return this.transmittedBytesMetric;
    }

    private class SendContext
    extends NotifyOnceListener<Void>
    implements CheckedSupplier<BytesReference, IOException> {
        private final TcpChannel channel;
        private final CheckedSupplier<BytesReference, IOException> messageSupplier;
        private final ActionListener<Void> listener;
        private final Releasable optionalReleasable;
        private long messageSize = -1L;

        private SendContext(TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener) {
            this(channel, messageSupplier, listener, null);
        }

        private SendContext(TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener, Releasable optionalReleasable) {
            this.channel = channel;
            this.messageSupplier = messageSupplier;
            this.listener = listener;
            this.optionalReleasable = optionalReleasable;
        }

        @Override
        public BytesReference get() throws IOException {
            try {
                BytesReference message = this.messageSupplier.get();
                this.messageSize = message.length();
                OutboundHandler.this.transportLogger.logOutboundMessage(this.channel, message);
                return message;
            }
            catch (Exception e) {
                this.onFailure(e);
                throw e;
            }
        }

        @Override
        protected void innerOnResponse(Void v) {
            assert (this.messageSize != -1L) : "If onResponse is being called, the message should have been serialized";
            OutboundHandler.this.transmittedBytesMetric.inc(this.messageSize);
            this.closeAndCallback(() -> this.listener.onResponse(v));
        }

        @Override
        protected void innerOnFailure(Exception e) {
            logger.warn(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            this.closeAndCallback(() -> this.listener.onFailure(e));
        }

        private void closeAndCallback(Runnable runnable) {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = this.optionalReleasable;
            releasableArray[1] = runnable::run;
            Releasables.close(releasableArray);
        }
    }

    private static class MessageSerializer
    implements CheckedSupplier<BytesReference, IOException>,
    Releasable {
        private final OutboundMessage message;
        private final BigArrays bigArrays;
        private volatile ReleasableBytesStreamOutput bytesStreamOutput;

        private MessageSerializer(OutboundMessage message, BigArrays bigArrays) {
            this.message = message;
            this.bigArrays = bigArrays;
        }

        @Override
        public BytesReference get() throws IOException {
            this.bytesStreamOutput = new ReleasableBytesStreamOutput(this.bigArrays);
            return this.message.serialize(this.bytesStreamOutput);
        }

        @Override
        public void close() {
            IOUtils.closeWhileHandlingException(this.bytesStreamOutput);
        }
    }
}

