/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.SizeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsExecutors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.node.Node;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ExecutorBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;

public final class FixedExecutorBuilder
extends ExecutorBuilder<FixedExecutorSettings> {
    private final Setting<Integer> sizeSetting;
    private final Setting<Integer> fallbackSizeSetting;
    private final Setting<Integer> queueSizeSetting;
    private final Setting<Integer> fallbackQueueSizeSetting;

    FixedExecutorBuilder(Settings settings, String name, int size, int queueSize) {
        this(settings, name, size, queueSize, false);
    }

    FixedExecutorBuilder(Settings settings, String name, String fallbackName, int size, int queueSize) {
        this(settings, name, fallbackName, size, queueSize, "thread_pool." + name, "thread_pool." + fallbackName, false);
    }

    FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, boolean deprecated) {
        this(settings, name, null, size, queueSize, "thread_pool." + name, null, deprecated);
    }

    public FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, String prefix) {
        this(settings, name, null, size, queueSize, prefix, null, false);
    }

    private FixedExecutorBuilder(Settings settings, String name, String fallbackName, int size, int queueSize, String prefix, String fallbackPrefix, boolean deprecated) {
        super(name);
        String sizeKey = FixedExecutorBuilder.settingsKey(prefix, "size");
        String queueSizeKey = FixedExecutorBuilder.settingsKey(prefix, "queue_size");
        if (fallbackName == null) {
            Setting.Property[] properties = deprecated ? new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated} : new Setting.Property[]{Setting.Property.NodeScope};
            assert (fallbackPrefix == null);
            this.sizeSetting = this.sizeSetting(settings, name, size, prefix, properties);
            this.fallbackSizeSetting = null;
            this.queueSizeSetting = this.queueSizeSetting(prefix, queueSize, properties);
            this.fallbackQueueSizeSetting = null;
        } else {
            assert (fallbackPrefix != null);
            assert (!deprecated);
            Setting.Property[] properties = new Setting.Property[]{Setting.Property.NodeScope};
            Setting.Property[] fallbackProperties = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated};
            Setting<Integer> fallbackSizeSetting = this.sizeSetting(settings, fallbackName, size, fallbackPrefix, fallbackProperties);
            this.sizeSetting = new Setting<Integer>((Setting.Key)new Setting.SimpleKey(sizeKey), fallbackSizeSetting, s2 -> Setting.parseInt(s2, 1, this.applyHardSizeLimit(settings, name), sizeKey), properties);
            this.fallbackSizeSetting = fallbackSizeSetting;
            Setting<Integer> fallbackQueueSizeSetting = this.queueSizeSetting(fallbackPrefix, queueSize, fallbackProperties);
            this.queueSizeSetting = new Setting<Integer>((Setting.Key)new Setting.SimpleKey(queueSizeKey), fallbackQueueSizeSetting, s2 -> Setting.parseInt(s2, Integer.MIN_VALUE, queueSizeKey), properties);
            this.fallbackQueueSizeSetting = fallbackQueueSizeSetting;
        }
    }

    private Setting<Integer> sizeSetting(Settings settings, String name, int size, String prefix, Setting.Property[] properties) {
        String sizeKey = FixedExecutorBuilder.settingsKey(prefix, "size");
        return new Setting<Integer>(sizeKey, s2 -> Integer.toString(size), s2 -> Setting.parseInt(s2, 1, this.applyHardSizeLimit(settings, name), sizeKey), properties);
    }

    private Setting<Integer> queueSizeSetting(String prefix, int queueSize, Setting.Property[] properties) {
        return Setting.intSetting(FixedExecutorBuilder.settingsKey(prefix, "queue_size"), queueSize, properties);
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        if (this.fallbackSizeSetting == null && this.fallbackQueueSizeSetting == null) {
            return Arrays.asList(this.sizeSetting, this.queueSizeSetting);
        }
        assert (this.fallbackSizeSetting != null && this.fallbackQueueSizeSetting != null);
        return Arrays.asList(this.sizeSetting, this.fallbackSizeSetting, this.queueSizeSetting, this.fallbackQueueSizeSetting);
    }

    @Override
    FixedExecutorSettings getSettings(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int size = this.sizeSetting.get(settings);
        int queueSize = this.queueSizeSetting.get(settings);
        return new FixedExecutorSettings(nodeName, size, queueSize);
    }

    @Override
    ThreadPool.ExecutorHolder build(FixedExecutorSettings settings, ThreadContext threadContext) {
        int size = settings.size;
        int queueSize = settings.queueSize;
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings.nodeName, this.name()));
        EsThreadPoolExecutor executor = EsExecutors.newFixed(settings.nodeName + "/" + this.name(), size, queueSize, threadFactory, threadContext);
        String name = "write".equals(this.name()) && Booleans.parseBoolean(System.getProperty("es.thread_pool.write.use_bulk_as_display_name", "false")) ? "bulk" : this.name();
        ThreadPool.Info info = new ThreadPool.Info(name, ThreadPool.ThreadPoolType.FIXED, size, size, null, queueSize < 0 ? null : new SizeValue(queueSize));
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], size [%d], queue size [%s]", info.getName(), info.getMax(), info.getQueueSize() == null ? "unbounded" : info.getQueueSize());
    }

    static class FixedExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        private final int size;
        private final int queueSize;

        FixedExecutorSettings(String nodeName, int size, int queueSize) {
            super(nodeName);
            this.size = size;
            this.queueSize = queueSize;
        }
    }
}

