/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.Timer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation.AggregationTimingType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation.ProfilingLeafBucketCollector;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) throws IOException {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean needsScores() {
        return this.delegate.needsScores();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public SearchContext context() {
        return this.delegate.context();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        InternalAggregation result;
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_AGGREGATION);
        timer.start();
        try {
            result = this.delegate.buildAggregation(bucket);
        }
        finally {
            timer.stop();
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        return new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(ctx), this.profileBreakdown);
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.INITIALIZE);
        timer.start();
        try {
            this.delegate.preCollection();
        }
        finally {
            timer.stop();
        }
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        this.delegate.postCollection();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static Aggregator unwrap(Aggregator agg) {
        if (agg instanceof ProfilingAggregator) {
            return ((ProfilingAggregator)agg).delegate;
        }
        return agg;
    }
}

