/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.ProfileResult;

public final class AggregationProfileShardResult
implements Writeable,
ToXContentFragment {
    public static final String AGGREGATIONS = "aggregations";
    private final List<ProfileResult> aggProfileResults;

    public AggregationProfileShardResult(List<ProfileResult> aggProfileResults) {
        this.aggProfileResults = aggProfileResults;
    }

    public AggregationProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.aggProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.aggProfileResults.add(new ProfileResult(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggProfileResults.size());
        for (ProfileResult p : this.aggProfileResults) {
            p.writeTo(out);
        }
    }

    public List<ProfileResult> getProfileResults() {
        return Collections.unmodifiableList(this.aggProfileResults);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(AGGREGATIONS);
        for (ProfileResult p : this.aggProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static AggregationProfileShardResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser::getTokenLocation);
        ArrayList<ProfileResult> aggProfileResults = new ArrayList<ProfileResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            aggProfileResults.add(ProfileResult.fromXContent(parser));
        }
        return new AggregationProfileShardResult(aggProfileResults);
    }
}

