/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Bits;

final class CancellableBulkScorer
extends BulkScorer {
    private static final int INITIAL_INTERVAL = 2048;
    private static final int MAX_INTERVAL = 0x100000;
    private final BulkScorer scorer;
    private final Runnable checkCancelled;

    CancellableBulkScorer(BulkScorer scorer, Runnable checkCancelled) {
        this.scorer = Objects.requireNonNull(scorer);
        this.checkCancelled = Objects.requireNonNull(checkCancelled);
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
        int interval = 2048;
        while (min2 < max) {
            this.checkCancelled.run();
            int newMax = (int)Math.min((long)min2 + (long)interval, (long)max);
            min2 = this.scorer.score(collector, acceptDocs, min2, newMax);
            interval = Math.min(interval << 1, 0x100000);
        }
        this.checkCancelled.run();
        return min2;
    }

    @Override
    public long cost() {
        return this.scorer.cost();
    }
}

