/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.highlight.Encoder;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.BoundedBreakIteratorScanner;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.CustomPassageFormatter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.CustomSeparatorBreakIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.Snippet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.logging.log4j.LogManager;

public class UnifiedHighlighter
implements Highlighter {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(UnifiedHighlighter.class));

    @Override
    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        MappedFieldType fieldType = highlighterContext.fieldType;
        SearchContextHighlight.Field field = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        Encoder encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        ArrayList<Snippet> snippets = new ArrayList<Snippet>();
        try {
            Snippet[] fieldSnippets;
            int numberOfFragments;
            CustomUnifiedHighlighter highlighter;
            Analyzer analyzer = this.getAnalyzer(context.mapperService().documentMapper(hitContext.hit().getType()), fieldType, hitContext);
            List<Object> fieldValues = this.loadFieldValues(fieldType, field, context, hitContext);
            if (fieldValues.size() == 0) {
                return null;
            }
            PassageFormatter passageFormatter = this.getPassageFormatter(hitContext, field, encoder);
            IndexSearcher searcher = new IndexSearcher(hitContext.reader());
            String fieldValue = UnifiedHighlighter.mergeFieldValues(fieldValues, '\u0000');
            UnifiedHighlighter.OffsetSource offsetSource = this.getOffsetSource(fieldType);
            int maxAnalyzedOffset = context.indexShard().indexSettings().getHighlightMaxAnalyzedOffset();
            int maxAnalyzedOffset7 = 1000000;
            if (offsetSource == UnifiedHighlighter.OffsetSource.ANALYSIS && maxAnalyzedOffset == -1 && fieldValue.length() > 1000000) {
                deprecationLogger.deprecated("The length [" + fieldValue.length() + "] of [" + highlighterContext.fieldName + "] field of [" + hitContext.hit().getId() + "] doc of [" + context.indexShard().shardId().getIndexName() + "] index has exceeded the allowed maximum of [" + 1000000 + "] set for the next major Elastic version. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!", new Object[0]);
            }
            if (offsetSource == UnifiedHighlighter.OffsetSource.ANALYSIS && maxAnalyzedOffset > 0 && fieldValue.length() > maxAnalyzedOffset) {
                throw new IllegalArgumentException("The length [" + fieldValue.length() + "] of [" + highlighterContext.fieldName + "] field of [" + hitContext.hit().getId() + "] doc of [" + context.indexShard().shardId().getIndexName() + "] index has exceeded [" + maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!");
            }
            if (field.fieldOptions().numberOfFragments() == 0) {
                CustomSeparatorBreakIterator breakIterator = new CustomSeparatorBreakIterator('\u0000');
                highlighter = new CustomUnifiedHighlighter(searcher, analyzer, offsetSource, passageFormatter, field.fieldOptions().boundaryScannerLocale(), breakIterator, fieldValue, field.fieldOptions().noMatchSize());
                numberOfFragments = fieldValues.size();
            } else {
                BreakIterator bi = this.getBreakIterator(field);
                highlighter = new CustomUnifiedHighlighter(searcher, analyzer, offsetSource, passageFormatter, field.fieldOptions().boundaryScannerLocale(), bi, fieldValue, field.fieldOptions().noMatchSize());
                numberOfFragments = field.fieldOptions().numberOfFragments();
            }
            if (field.fieldOptions().requireFieldMatch().booleanValue()) {
                String fieldName = highlighterContext.fieldName;
                highlighter.setFieldMatcher(name -> fieldName.equals(name));
            } else {
                highlighter.setFieldMatcher(name -> !"_id".equals(name));
            }
            for (Snippet fieldSnippet : fieldSnippets = highlighter.highlightField(highlighterContext.fieldName, highlighterContext.query, hitContext.docId(), numberOfFragments)) {
                if (!Strings.hasText(fieldSnippet.getText())) continue;
                snippets.add(fieldSnippet);
            }
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, (o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = ((Snippet)snippets.get(i)).getText();
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
        }
        return null;
    }

    protected PassageFormatter getPassageFormatter(FetchSubPhase.HitContext hitContext, SearchContextHighlight.Field field, Encoder encoder) {
        CustomPassageFormatter passageFormatter = new CustomPassageFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0], encoder);
        return passageFormatter;
    }

    protected Analyzer getAnalyzer(DocumentMapper docMapper, MappedFieldType type, FetchSubPhase.HitContext hitContext) {
        return HighlightUtils.getAnalyzer(docMapper, type);
    }

    protected List<Object> loadFieldValues(MappedFieldType fieldType, SearchContextHighlight.Field field, SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
        List<Object> fieldValues = HighlightUtils.loadFieldValues(field, fieldType, context, hitContext);
        fieldValues = fieldValues.stream().map(s2 -> UnifiedHighlighter.convertFieldValue(fieldType, s2)).collect(Collectors.toList());
        return fieldValues;
    }

    protected BreakIterator getBreakIterator(SearchContextHighlight.Field field) {
        SearchContextHighlight.FieldOptions fieldOptions = field.fieldOptions();
        Locale locale = fieldOptions.boundaryScannerLocale() != null ? fieldOptions.boundaryScannerLocale() : Locale.ROOT;
        HighlightBuilder.BoundaryScannerType type = fieldOptions.boundaryScannerType() != null ? fieldOptions.boundaryScannerType() : HighlightBuilder.BoundaryScannerType.SENTENCE;
        int maxLen = fieldOptions.fragmentCharSize();
        switch (type) {
            case SENTENCE: {
                if (maxLen > 0) {
                    return BoundedBreakIteratorScanner.getSentence(locale, maxLen);
                }
                return BreakIterator.getSentenceInstance(locale);
            }
            case WORD: {
                return BreakIterator.getWordInstance(locale);
            }
        }
        throw new IllegalArgumentException("Invalid boundary scanner type: " + type.toString());
    }

    protected static String convertFieldValue(MappedFieldType type, Object value) {
        if (value instanceof BytesRef) {
            return type.valueForDisplay(value).toString();
        }
        return value.toString();
    }

    protected static String mergeFieldValues(List<Object> fieldValues, char valuesSeparator) {
        String rawValue = Strings.collectionToDelimitedString(fieldValues, String.valueOf(valuesSeparator));
        return rawValue.substring(0, Math.min(rawValue.length(), 0x7FFFFFFE));
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(MappedFieldType fieldType) {
        if (fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
            return fieldType.storeTermVectors() ? UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS : UnifiedHighlighter.OffsetSource.POSTINGS;
        }
        if (fieldType.storeTermVectorOffsets()) {
            return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
        }
        return UnifiedHighlighter.OffsetSource.ANALYSIS;
    }
}

