/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.dfs;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.CollectionStatistics;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TermStatistics;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.HppcMaps;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.dfs.DfsSearchResult;

public class AggregatedDfs
implements Streamable {
    private ObjectObjectHashMap<Term, TermStatistics> termStatistics;
    private ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics;
    private long maxDoc;

    private AggregatedDfs() {
    }

    public AggregatedDfs(ObjectObjectHashMap<Term, TermStatistics> termStatistics, ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics, long maxDoc) {
        this.termStatistics = termStatistics;
        this.fieldStatistics = fieldStatistics;
        this.maxDoc = maxDoc;
    }

    public ObjectObjectHashMap<Term, TermStatistics> termStatistics() {
        return this.termStatistics;
    }

    public ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public long maxDoc() {
        return this.maxDoc;
    }

    public static AggregatedDfs readAggregatedDfs(StreamInput in) throws IOException {
        AggregatedDfs result = new AggregatedDfs();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.termStatistics = HppcMaps.newMap(size);
        for (int i = 0; i < size; ++i) {
            Term term = new Term(in.readString(), in.readBytesRef());
            TermStatistics stats = new TermStatistics(in.readBytesRef(), in.readVLong(), DfsSearchResult.subOne(in.readVLong()));
            this.termStatistics.put(term, stats);
        }
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.termStatistics.size());
        for (ObjectObjectCursor<Term, TermStatistics> objectObjectCursor : this.termStatistics()) {
            Term term = (Term)objectObjectCursor.key;
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
            TermStatistics stats = (TermStatistics)objectObjectCursor.value;
            out.writeBytesRef(stats.term());
            out.writeVLong(stats.docFreq());
            out.writeVLong(DfsSearchResult.addOne(stats.totalTermFreq()));
        }
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVLong(this.maxDoc);
    }
}

