/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.avg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;

public class AvgBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private int count = 0;
    private double sum = 0.0;

    protected AvgBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, format, metaData);
    }

    public AvgBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "avg_bucket";
    }

    @Override
    protected void preCollection() {
        this.count = 0;
        this.sum = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        ++this.count;
        this.sum += bucketValue.doubleValue();
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        double avgValue = this.count == 0 ? Double.NaN : this.sum / (double)this.count;
        return new InternalSimpleValue(this.name(), avgValue, this.format, pipelineAggregators, metadata);
    }
}

