/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.weighted_avg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.DoubleArray;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.weighted_avg.InternalWeightedAvg;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.weighted_avg.WeightedAvgAggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public class WeightedAvgAggregator
extends NumericMetricsAggregator.SingleValue {
    private final MultiValuesSource.NumericMultiValuesSource valuesSources;
    private DoubleArray weights;
    private DoubleArray sums;
    private DoubleArray sumCompensations;
    private DoubleArray weightCompensations;
    private DocValueFormat format;

    public WeightedAvgAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, DocValueFormat format, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSources = valuesSources;
        this.format = format;
        if (valuesSources != null) {
            BigArrays bigArrays = context.bigArrays();
            this.weights = bigArrays.newDoubleArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.sumCompensations = bigArrays.newDoubleArray(1L, true);
            this.weightCompensations = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSources != null && this.valuesSources.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues docValues = this.valuesSources.getField(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName(), ctx);
        final SortedNumericDoubleValues docWeights = this.valuesSources.getField(WeightedAvgAggregationBuilder.WEIGHT_FIELD.getPreferredName(), ctx);
        return new LeafBucketCollectorBase(sub, docValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                WeightedAvgAggregator.this.weights = bigArrays.grow(WeightedAvgAggregator.this.weights, bucket + 1L);
                WeightedAvgAggregator.this.sums = bigArrays.grow(WeightedAvgAggregator.this.sums, bucket + 1L);
                WeightedAvgAggregator.this.sumCompensations = bigArrays.grow(WeightedAvgAggregator.this.sumCompensations, bucket + 1L);
                WeightedAvgAggregator.this.weightCompensations = bigArrays.grow(WeightedAvgAggregator.this.weightCompensations, bucket + 1L);
                if (docValues.advanceExact(doc) && docWeights.advanceExact(doc)) {
                    if (docWeights.docValueCount() > 1) {
                        throw new AggregationExecutionException("Encountered more than one weight for a single document. Use a script to combine multiple weights-per-doc into a single value.");
                    }
                    assert (docWeights.docValueCount() == 1);
                    double weight = docWeights.nextValue();
                    int numValues = docValues.docValueCount();
                    assert (numValues > 0);
                    for (int i = 0; i < numValues; ++i) {
                        WeightedAvgAggregator.kahanSum(docValues.nextValue() * weight, WeightedAvgAggregator.this.sums, WeightedAvgAggregator.this.sumCompensations, bucket);
                        WeightedAvgAggregator.kahanSum(weight, WeightedAvgAggregator.this.weights, WeightedAvgAggregator.this.weightCompensations, bucket);
                    }
                }
            }
        };
    }

    private static void kahanSum(double value, DoubleArray values, DoubleArray compensations, long bucket) {
        double sum = values.get(bucket);
        double compensation = compensations.get(bucket);
        if (!Double.isFinite(value)) {
            sum += value;
        } else if (Double.isFinite(sum)) {
            double corrected = value - compensation;
            double newSum = sum + corrected;
            compensation = newSum - sum - corrected;
            sum = newSum;
        }
        values.set(bucket, sum);
        compensations.set(bucket, compensation);
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSources == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / this.weights.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalWeightedAvg(this.name, this.sums.get(bucket), this.weights.get(bucket), this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalWeightedAvg(this.name, 0.0, 0.0, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.weights, this.sums, this.sumCompensations, this.weightCompensations);
    }
}

