/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous.DeDuplicatingTokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous.DuplicateByteSequenceSpotter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BytesRefHash;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.SignificantTextAggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.ContextIndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.lookup.SourceLookup;

public class SignificantTextAggregator
extends BucketsAggregator {
    private final IncludeExclude.StringFilter includeExclude;
    protected final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    protected long numCollectedDocs;
    private final BytesRefHash bucketOrds;
    private final SignificanceHeuristic significanceHeuristic;
    private SignificantTextAggregatorFactory termsAggFactory;
    private final DocValueFormat format = DocValueFormat.RAW;
    private final String fieldName;
    private final String[] sourceFieldNames;
    private DuplicateByteSequenceSpotter dupSequenceSpotter = null;
    private long lastTrieSize;
    private static final int MEMORY_GROWTH_REPORTING_INTERVAL_BYTES = 5000;

    public SignificantTextAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, SignificanceHeuristic significanceHeuristic, SignificantTextAggregatorFactory termsAggFactory, String fieldName, String[] sourceFieldNames, boolean filterDuplicateText, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.bucketCountThresholds = bucketCountThresholds;
        this.includeExclude = includeExclude;
        this.significanceHeuristic = significanceHeuristic;
        this.termsAggFactory = termsAggFactory;
        this.fieldName = fieldName;
        this.sourceFieldNames = sourceFieldNames;
        this.bucketOrds = new BytesRefHash(1L, context.bigArrays());
        if (filterDuplicateText) {
            this.dupSequenceSpotter = new DuplicateByteSequenceSpotter();
            this.lastTrieSize = this.dupSequenceSpotter.getEstimatedSizeInBytes();
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final BytesRefBuilder previous = new BytesRefBuilder();
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                this.collectFromSource(doc, bucket, SignificantTextAggregator.this.fieldName, SignificantTextAggregator.this.sourceFieldNames);
                ++SignificantTextAggregator.this.numCollectedDocs;
                if (SignificantTextAggregator.this.dupSequenceSpotter != null) {
                    SignificantTextAggregator.this.dupSequenceSpotter.startNewSequence();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processTokenStream(int doc, long bucket, TokenStream ts, BytesRefHash inDocTerms, String fieldText) throws IOException {
                if (SignificantTextAggregator.this.dupSequenceSpotter != null) {
                    ts = new DeDuplicatingTokenFilter(ts, SignificantTextAggregator.this.dupSequenceSpotter);
                }
                CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
                ts.reset();
                try {
                    while (ts.incrementToken()) {
                        long newTrieSize;
                        long growth;
                        if (SignificantTextAggregator.this.dupSequenceSpotter != null && (growth = (newTrieSize = SignificantTextAggregator.this.dupSequenceSpotter.getEstimatedSizeInBytes()) - SignificantTextAggregator.this.lastTrieSize) > 5000L) {
                            SignificantTextAggregator.this.addRequestCircuitBreakerBytes(growth);
                            SignificantTextAggregator.this.lastTrieSize = newTrieSize;
                        }
                        previous.clear();
                        previous.copyChars(termAtt);
                        BytesRef bytes = previous.get();
                        if (inDocTerms.add(bytes) < 0L || SignificantTextAggregator.this.includeExclude != null && !SignificantTextAggregator.this.includeExclude.accept(bytes)) continue;
                        long bucketOrdinal = SignificantTextAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            SignificantTextAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                            continue;
                        }
                        SignificantTextAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                    }
                }
                finally {
                    ts.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void collectFromSource(int doc, long bucket, String indexedFieldName, String[] sourceFieldNames) throws IOException {
                MappedFieldType fieldType = SignificantTextAggregator.this.context.getQueryShardContext().fieldMapper(indexedFieldName);
                if (fieldType == null) {
                    throw new IllegalArgumentException("Aggregation [" + SignificantTextAggregator.this.name + "] cannot process field [" + indexedFieldName + "] since it is not present");
                }
                SourceLookup sourceLookup = SignificantTextAggregator.this.context.lookup().source();
                sourceLookup.setSegmentAndDocument(ctx, doc);
                BytesRefHash inDocTerms = new BytesRefHash(256L, SignificantTextAggregator.this.context.bigArrays());
                try {
                    for (String sourceField : sourceFieldNames) {
                        List<Object> textsToHighlight = sourceLookup.extractRawValues(sourceField);
                        textsToHighlight = textsToHighlight.stream().map(obj -> {
                            if (obj instanceof BytesRef) {
                                return fieldType.valueForDisplay(obj).toString();
                            }
                            return obj;
                        }).collect(Collectors.toList());
                        NamedAnalyzer analyzer = fieldType.indexAnalyzer();
                        for (Object fieldValue : textsToHighlight) {
                            String fieldText = fieldValue.toString();
                            TokenStream ts = analyzer.tokenStream(indexedFieldName, fieldText);
                            this.processTokenStream(doc, bucket, ts, inDocTerms, fieldText);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Releasables.close(inDocTerms);
                    throw throwable;
                }
                Releasables.close(inDocTerms);
            }
        };
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.getSupersetNumDocs();
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        int i = 0;
        while ((long)i < this.bucketOrds.size()) {
            int docCount = this.bucketDocCount(i);
            if ((long)docCount >= this.bucketCountThresholds.getShardMinDocCount()) {
                if (spare == null) {
                    spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null, this.format);
                }
                this.bucketOrds.get(i, spare.termBytes);
                spare.subsetDf = docCount;
                spare.subsetSize = subsetSize;
                spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
                spare.supersetSize = supersetSize;
                spare.updateScore(this.significanceHeuristic);
                spare.bucketOrd = i;
                spare = ordered.insertWithOverflow(spare);
                if (spare == null) {
                    this.consumeBucketsAndMaybeBreak(1);
                }
            }
            ++i;
        }
        SignificantStringTerms.Bucket[] list = new SignificantStringTerms.Bucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf(bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return new SignificantStringTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, subsetSize, supersetSize, this.significanceHeuristic, Arrays.asList(list));
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, 0L, (long)supersetSize, this.significanceHeuristic, Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds, this.termsAggFactory);
    }
}

