/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.InternalMappedSignificantTerms;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class SignificantStringTerms
extends InternalMappedSignificantTerms<SignificantStringTerms, Bucket> {
    public static final String NAME = "sigsterms";

    public SignificantStringTerms(String name, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, long subsetSize, long supersetSize, SignificanceHeuristic significanceHeuristic, List<Bucket> buckets) {
        super(name, requiredSize, minDocCount, pipelineAggregators, metaData, format, subsetSize, supersetSize, significanceHeuristic, buckets);
    }

    public SignificantStringTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public SignificantStringTerms create(List<Bucket> buckets) {
        return new SignificantStringTerms(this.name, this.requiredSize, this.minDocCount, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, this.subsetSize, this.supersetSize, this.significanceHeuristic, buckets);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.subsetDf, prototype.subsetSize, prototype.supersetDf, prototype.supersetSize, aggregations, prototype.format);
    }

    @Override
    protected SignificantStringTerms create(long subsetSize, long supersetSize, List<Bucket> buckets) {
        return new SignificantStringTerms(this.getName(), this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.getMetaData(), this.format, subsetSize, supersetSize, this.significanceHeuristic, buckets);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    public static class Bucket
    extends InternalSignificantTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term, long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, DocValueFormat format) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations, format);
            this.termBytes = term;
        }

        public Bucket(StreamInput in, long subsetSize, long supersetSize, DocValueFormat format) throws IOException {
            super(in, subsetSize, supersetSize, format);
            this.termBytes = in.readBytesRef();
            this.subsetDf = in.readVLong();
            this.supersetDf = in.readVLong();
            this.score = in.readDouble();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
            out.writeVLong(this.subsetDf);
            out.writeVLong(this.supersetDf);
            out.writeDouble(this.getSignificanceScore());
            this.aggregations.writeTo(out);
        }

        public Bucket(BytesRef term, long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, double score, DocValueFormat format) {
            this(term, subsetDf, subsetSize, supersetDf, supersetSize, aggregations, format);
            this.score = score;
        }

        @Override
        public Number getKeyAsNumber() {
            return Double.parseDouble(this.termBytes.utf8ToString());
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.termBytes).toString();
        }

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        Bucket newBucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            return new Bucket(this.termBytes, subsetDf, subsetSize, supersetDf, supersetSize, aggregations, this.format);
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }
}

