/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.CollectionTerminatedException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.packed.PackedLongValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.LongHash;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.BucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public class BestBucketsDeferringCollector
extends DeferringBucketCollector {
    final List<Entry> entries = new ArrayList<Entry>();
    BucketCollector collector;
    final SearchContext searchContext;
    final boolean isGlobal;
    LeafReaderContext context;
    PackedLongValues.Builder docDeltas;
    PackedLongValues.Builder buckets;
    long maxBucket = -1L;
    boolean finished = false;
    LongHash selectedBuckets;

    public BestBucketsDeferringCollector(SearchContext context, boolean isGlobal) {
        this.searchContext = context;
        this.isGlobal = isGlobal;
    }

    @Override
    public boolean needsScores() {
        if (this.collector == null) {
            throw new IllegalStateException();
        }
        return this.collector.needsScores();
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.collector = MultiBucketCollector.wrap(deferredCollectors);
    }

    private void finishLeaf() {
        if (this.context != null) {
            this.entries.add(new Entry(this.context, this.docDeltas.build(), this.buckets.build()));
        }
        this.context = null;
        this.docDeltas = null;
        this.buckets = null;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        this.finishLeaf();
        this.context = ctx;
        this.docDeltas = PackedLongValues.packedBuilder(0.25f);
        this.buckets = PackedLongValues.packedBuilder(0.25f);
        return new LeafBucketCollector(){
            int lastDoc = 0;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                BestBucketsDeferringCollector.this.docDeltas.add(doc - this.lastDoc);
                BestBucketsDeferringCollector.this.buckets.add(bucket);
                this.lastDoc = doc;
                BestBucketsDeferringCollector.this.maxBucket = Math.max(BestBucketsDeferringCollector.this.maxBucket, bucket);
            }
        };
    }

    @Override
    public void preCollection() throws IOException {
        this.collector.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.finishLeaf();
        this.finished = true;
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
        if (!this.finished) {
            throw new IllegalStateException("Cannot replay yet, collection is not finished: postCollect() has not been called");
        }
        if (this.selectedBuckets != null) {
            throw new IllegalStateException("Already been replayed");
        }
        LongHash hash = new LongHash(selectedBuckets.length, BigArrays.NON_RECYCLING_INSTANCE);
        for (long bucket : selectedBuckets) {
            hash.add(bucket);
        }
        this.selectedBuckets = hash;
        boolean needsScores = this.needsScores();
        Weight weight = null;
        if (needsScores) {
            Query query = this.isGlobal ? new MatchAllDocsQuery() : this.searchContext.query();
            weight = this.searchContext.searcher().createNormalizedWeight(query, true);
        }
        for (Entry entry : this.entries) {
            try {
                LeafBucketCollector leafCollector = this.collector.getLeafCollector(entry.context);
                DocIdSetIterator docIt = null;
                if (needsScores && entry.docDeltas.size() > 0L) {
                    Scorer scorer = weight.scorer(entry.context);
                    docIt = scorer.iterator();
                    leafCollector.setScorer(scorer);
                }
                PackedLongValues.Iterator docDeltaIterator = entry.docDeltas.iterator();
                PackedLongValues.Iterator buckets = entry.buckets.iterator();
                int doc = 0;
                long end = entry.docDeltas.size();
                for (long i = 0L; i < end; ++i) {
                    doc = (int)((long)doc + docDeltaIterator.next());
                    long bucket = buckets.next();
                    long rebasedBucket = hash.find(bucket);
                    if (rebasedBucket == -1L) continue;
                    if (needsScores) {
                        if (docIt.docID() < doc) {
                            docIt.advance(doc);
                        }
                        assert (docIt.docID() == doc);
                    }
                    leafCollector.collect(doc, rebasedBucket);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
            }
        }
        this.collector.postCollection();
    }

    @Override
    public Aggregator wrap(final Aggregator in) {
        return new DeferringBucketCollector.WrappedAggregator(in){

            @Override
            public InternalAggregation buildAggregation(long bucket) throws IOException {
                if (BestBucketsDeferringCollector.this.selectedBuckets == null) {
                    throw new IllegalStateException("Collection has not been replayed yet.");
                }
                long rebasedBucket = BestBucketsDeferringCollector.this.selectedBuckets.find(bucket);
                if (rebasedBucket == -1L) {
                    throw new IllegalStateException("Cannot build for a bucket which has not been collected");
                }
                return in.buildAggregation(rebasedBucket);
            }
        };
    }

    private static class Entry {
        final LeafReaderContext context;
        final PackedLongValues docDeltas;
        final PackedLongValues buckets;

        Entry(LeafReaderContext context, PackedLongValues docDeltas, PackedLongValues buckets) {
            this.context = context;
            this.docDeltas = docDeltas;
            this.buckets = buckets;
        }
    }
}

