/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.AllocatedPersistentTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.PersistentTaskParams;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.PersistentTaskState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.TaskId;

public abstract class PersistentTasksExecutor<Params extends PersistentTaskParams> {
    private final String executor;
    private final String taskName;
    public static final PersistentTasksCustomMetaData.Assignment NO_NODE_FOUND = new PersistentTasksCustomMetaData.Assignment(null, "no appropriate nodes found for the assignment");

    protected PersistentTasksExecutor(String taskName, String executor) {
        this.taskName = taskName;
        this.executor = executor;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public PersistentTasksCustomMetaData.Assignment getAssignment(Params params, ClusterState clusterState) {
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, DiscoveryNode::isDataNode);
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetaData.Assignment(discoveryNode.getId(), "");
    }

    protected DiscoveryNode selectLeastLoadedNode(ClusterState clusterState, Predicate<DiscoveryNode> selector) {
        long minLoad = Long.MAX_VALUE;
        DiscoveryNode minLoadedNode = null;
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!selector.test(node)) continue;
            if (persistentTasks == null) {
                return node;
            }
            long numberOfTasks = persistentTasks.getNumberOfTasksOnNode(node.getId(), this.taskName);
            if (minLoad <= numberOfTasks) continue;
            minLoad = numberOfTasks;
            minLoadedNode = node;
        }
        return minLoadedNode;
    }

    public void validate(Params params, ClusterState clusterState) {
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<Params> taskInProgress, Map<String, String> headers) {
        return new AllocatedPersistentTask(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers);
    }

    protected String getDescription(PersistentTasksCustomMetaData.PersistentTask<Params> taskInProgress) {
        return "id=" + taskInProgress.getId();
    }

    protected abstract void nodeOperation(AllocatedPersistentTask var1, Params var2, @Nullable PersistentTaskState var3);

    public String getExecutor() {
        return this.executor;
    }
}

