/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.FSDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.FileSwitchDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.LockFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.MMapDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.NIOFSDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.NativeFSLockFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexModule;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardPath;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.DirectoryService;

public class FsDirectoryService
extends DirectoryService {
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s2 -> {
        switch (s2) {
            case "native": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "simple": {
                return SimpleFSLockFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s2 + "\": must be native or simple");
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);
    private final ShardPath path;

    @Inject
    public FsDirectoryService(IndexSettings indexSettings, ShardPath path) {
        super(path.getShardId(), indexSettings);
        this.path = path;
    }

    @Override
    public Directory newDirectory() throws IOException {
        Path location = this.path.resolveIndex();
        LockFactory lockFactory = this.indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        Directory wrapped = this.newFSDirectory(location, lockFactory);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)this.indexSettings.getValue(IndexModule.INDEX_STORE_PRE_LOAD_SETTING));
        wrapped = FsDirectoryService.setPreload(wrapped, location, lockFactory, preLoadExtensions);
        return wrapped;
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory) throws IOException {
        String storeType = this.indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        IndexModule.Type type = IndexModule.Type.FS.match(storeType) ? IndexModule.defaultStoreType(IndexModule.NODE_STORE_ALLOW_MMAP.get(this.indexSettings.getNodeSettings())) : IndexModule.Type.fromSettingsKey(storeType);
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open(location, lockFactory);
                if (primaryDirectory instanceof MMapDirectory) {
                    return new HybridDirectory(location, lockFactory, primaryDirectory);
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                return new MMapDirectory(location, lockFactory);
            }
            case SIMPLEFS: {
                return new SimpleFSDirectory(location, lockFactory);
            }
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + (Object)((Object)type) + "]"));
    }

    private static Directory setPreload(Directory directory, Path location, LockFactory lockFactory, Set<String> preLoadExtensions) throws IOException {
        if (!preLoadExtensions.isEmpty() && directory instanceof MMapDirectory && !((MMapDirectory)directory).getPreload()) {
            if (preLoadExtensions.contains("*")) {
                ((MMapDirectory)directory).setPreload(true);
                return directory;
            }
            final MMapDirectory primary = new MMapDirectory(location, lockFactory);
            primary.setPreload(true);
            return new FileSwitchDirectory(preLoadExtensions, primary, directory, true){

                @Override
                public String[] listAll() throws IOException {
                    return primary.listAll();
                }
            };
        }
        return directory;
    }

    static final class HybridDirectory
    extends NIOFSDirectory {
        private final FSDirectory randomAccessDirectory;

        HybridDirectory(Path location, LockFactory lockFactory, FSDirectory randomAccessDirectory) throws IOException {
            super(location, lockFactory);
            this.randomAccessDirectory = randomAccessDirectory;
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            String extension;
            switch (extension = FileSwitchDirectory.getExtension(name)) {
                case "nvd": 
                case "dvd": 
                case "tim": 
                case "cfs": {
                    this.ensureOpen();
                    this.ensureCanRead(name);
                    return this.randomAccessDirectory.openInput(name, context);
                }
            }
            return super.openInput(name, context);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(() -> super.close(), this.randomAccessDirectory);
        }

        Directory getRandomAccessDirectory() {
            return this.randomAccessDirectory;
        }
    }
}

