/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.FilterMergePolicy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.MergePolicy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentInfos;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ElasticsearchMergePolicy
extends FilterMergePolicy {
    private static Logger logger = LogManager.getLogger(ElasticsearchMergePolicy.class);
    private volatile boolean upgradeInProgress;
    private volatile boolean upgradeOnlyAncientSegments;
    private static final int MAX_CONCURRENT_UPGRADE_MERGES = 5;

    public ElasticsearchMergePolicy(MergePolicy delegate) {
        super(delegate);
    }

    private boolean shouldUpgrade(SegmentCommitInfo info) {
        org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version old = info.info.getVersion();
        org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version cur = Version.CURRENT.luceneVersion;
        assert (old.major <= cur.major);
        if (cur.major > old.major) {
            return true;
        }
        return !this.upgradeOnlyAncientSegments && cur.minor > old.minor;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        if (this.upgradeInProgress) {
            MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
            for (SegmentCommitInfo info : segmentInfos) {
                if (this.shouldUpgrade(info)) {
                    logger.debug("Adding segment {} to be upgraded", (Object)info.info.name);
                    spec.add(new MergePolicy.OneMerge(Collections.singletonList(info)));
                }
                if (spec.merges.size() != 5) continue;
                logger.debug("Returning {} merges for upgrade", (Object)spec.merges.size());
                return spec;
            }
            if (!spec.merges.isEmpty()) {
                logger.debug("Returning {} merges for end of upgrade", (Object)spec.merges.size());
                return spec;
            }
            this.upgradeInProgress = false;
        }
        return super.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, mergeContext);
    }

    public void setUpgradeInProgress(boolean upgrade, boolean onlyAncientSegments) {
        this.upgradeInProgress = upgrade;
        this.upgradeOnlyAncientSegments = onlyAncientSegments;
    }
}

