/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.plain;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.LatLonDocValuesField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.plain.LatLonPointDVAtomicFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.MultiValueMode;

public abstract class AbstractLatLonPointDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexGeoPointFieldData {
    AbstractLatLonPointDVIndexFieldData(Index index, String fieldName) {
        super(index, fieldName);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new LatLonPointDVIndexFieldData(indexSettings.getIndex(), fieldType.name());
        }
    }

    public static class LatLonPointDVIndexFieldData
    extends AbstractLatLonPointDVIndexFieldData {
        public LatLonPointDVIndexFieldData(Index index, String fieldName) {
            super(index, fieldName);
        }

        @Override
        public AtomicGeoPointFieldData load(LeafReaderContext context) {
            LeafReader reader = context.reader();
            FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
            if (info != null) {
                LatLonPointDVIndexFieldData.checkCompatible(info);
            }
            return new LatLonPointDVAtomicFieldData(reader, this.fieldName);
        }

        @Override
        public AtomicGeoPointFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        static void checkCompatible(FieldInfo fieldInfo) {
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != LatLonDocValuesField.TYPE.docValuesType()) {
                throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + (Object)((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + (Object)((Object)LatLonDocValuesField.TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
            }
        }
    }
}

