/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation;

import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.DiskUsage;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiskThresholdMonitor {
    private static final Logger logger = LogManager.getLogger(DiskThresholdMonitor.class);
    private final DiskThresholdSettings diskThresholdSettings;
    private final Client client;
    private final Set<String> nodeHasPassedWatermark = Sets.newConcurrentHashSet();
    private final Supplier<ClusterState> clusterStateSupplier;
    private long lastRunNS;

    public DiskThresholdMonitor(Settings settings, Supplier<ClusterState> clusterStateSupplier, ClusterSettings clusterSettings, Client client) {
        this.clusterStateSupplier = clusterStateSupplier;
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.client = client;
    }

    private void warnAboutDiskIfNeeded(DiskUsage usage) {
        if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdFloodStage().getBytes()) {
            logger.warn("flood stage disk watermark [{}] exceeded on {}, all indices on this node will be marked read-only", (Object)this.diskThresholdSettings.getFreeBytesThresholdFloodStage(), (Object)usage);
        } else if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes()) {
            logger.warn("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node", (Object)this.diskThresholdSettings.getFreeBytesThresholdHigh(), (Object)usage);
        } else if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes()) {
            logger.info("low disk watermark [{}] exceeded on {}, replicas will not be assigned to this node", (Object)this.diskThresholdSettings.getFreeBytesThresholdLow(), (Object)usage);
        }
        if (usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdFloodStage()) {
            logger.warn("flood stage disk watermark [{}] exceeded on {}, all indices on this node will be marked read-only", (Object)Strings.format1Decimals(100.0 - this.diskThresholdSettings.getFreeDiskThresholdFloodStage(), "%"), (Object)usage);
        } else if (usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
            logger.warn("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node", (Object)Strings.format1Decimals(100.0 - this.diskThresholdSettings.getFreeDiskThresholdHigh(), "%"), (Object)usage);
        } else if (usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow()) {
            logger.info("low disk watermark [{}] exceeded on {}, replicas will not be assigned to this node", (Object)Strings.format1Decimals(100.0 - this.diskThresholdSettings.getFreeDiskThresholdLow(), "%"), (Object)usage);
        }
    }

    public void onNewInfo(ClusterInfo info) {
        ImmutableOpenMap<String, DiskUsage> usages = info.getNodeLeastAvailableDiskUsages();
        if (usages != null) {
            boolean reroute = false;
            String explanation = "";
            ObjectLookupContainer<String> nodes = usages.keys();
            for (String node : this.nodeHasPassedWatermark) {
                if (nodes.contains(node)) continue;
                this.nodeHasPassedWatermark.remove(node);
            }
            ClusterState state = this.clusterStateSupplier.get();
            HashSet<String> indicesToMarkReadOnly = new HashSet<String>();
            for (ObjectObjectCursor<String, DiskUsage> objectObjectCursor : usages) {
                String node = (String)objectObjectCursor.key;
                DiskUsage usage = (DiskUsage)objectObjectCursor.value;
                this.warnAboutDiskIfNeeded(usage);
                if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdFloodStage().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdFloodStage()) {
                    RoutingNode routingNode = state.getRoutingNodes().node(node);
                    if (routingNode == null) continue;
                    for (ShardRouting routing : routingNode) {
                        indicesToMarkReadOnly.add(routing.index().getName());
                    }
                    continue;
                }
                if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
                    if (System.nanoTime() - this.lastRunNS > this.diskThresholdSettings.getRerouteInterval().nanos()) {
                        this.lastRunNS = System.nanoTime();
                        reroute = true;
                        explanation = "high disk watermark exceeded on one or more nodes";
                    } else {
                        logger.debug("high disk watermark exceeded on {} but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
                    }
                    this.nodeHasPassedWatermark.add(node);
                    continue;
                }
                if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow()) {
                    this.nodeHasPassedWatermark.add(node);
                    continue;
                }
                if (!this.nodeHasPassedWatermark.contains(node)) continue;
                if (System.nanoTime() - this.lastRunNS > this.diskThresholdSettings.getRerouteInterval().nanos()) {
                    this.lastRunNS = System.nanoTime();
                    reroute = true;
                    explanation = "one or more nodes has gone under the high or low watermark";
                    this.nodeHasPassedWatermark.remove(node);
                    continue;
                }
                logger.debug("{} has gone below a disk threshold, but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
            }
            if (reroute) {
                logger.info("rerouting shards: [{}]", (Object)explanation);
                this.reroute();
            }
            indicesToMarkReadOnly.removeIf(index -> state.getBlocks().indexBlocked(ClusterBlockLevel.WRITE, (String)index));
            if (!indicesToMarkReadOnly.isEmpty()) {
                this.markIndicesReadOnly(indicesToMarkReadOnly);
            }
        }
    }

    protected void markIndicesReadOnly(Set<String> indicesToMarkReadOnly) {
        this.client.admin().indices().prepareUpdateSettings(indicesToMarkReadOnly.toArray(Strings.EMPTY_ARRAY)).setSettings(Settings.builder().put("index.blocks.read_only_allow_delete", true).build()).execute();
    }

    protected void reroute() {
        this.client.admin().cluster().prepareReroute().execute();
    }
}

