/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.watcher;

import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.watcher.PutWatchRequest;

public final class ActivateWatchRequest
implements Validatable {
    private final String watchId;

    public ActivateWatchRequest(String watchId) {
        this.watchId = Objects.requireNonNull(watchId, "Watch identifier is required");
        if (!PutWatchRequest.isValidId(this.watchId)) {
            throw new IllegalArgumentException("Watch identifier contains whitespace");
        }
    }

    public String getWatchId() {
        return this.watchId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivateWatchRequest that = (ActivateWatchRequest)o;
        return Objects.equals(this.watchId, that.watchId);
    }

    public int hashCode() {
        int result = Objects.hash(this.watchId);
        return result;
    }
}

