/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.stats;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.NodeAttributes;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.config.Job;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.config.JobState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.process.DataCounts;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.process.ModelSizeStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.stats.ForecastStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class JobStats
implements ToXContentObject {
    private static final ParseField DATA_COUNTS = new ParseField("data_counts", new String[0]);
    private static final ParseField MODEL_SIZE_STATS = new ParseField("model_size_stats", new String[0]);
    private static final ParseField FORECASTS_STATS = new ParseField("forecasts_stats", new String[0]);
    private static final ParseField STATE = new ParseField("state", new String[0]);
    private static final ParseField NODE = new ParseField("node", new String[0]);
    private static final ParseField OPEN_TIME = new ParseField("open_time", new String[0]);
    private static final ParseField ASSIGNMENT_EXPLANATION = new ParseField("assignment_explanation", new String[0]);
    public static final ConstructingObjectParser<JobStats, Void> PARSER = new ConstructingObjectParser("job_stats", true, a -> {
        ModelSizeStats.Builder modelSizeStatsBuilder;
        int i = 0;
        String jobId = (String)a[i++];
        DataCounts dataCounts = (DataCounts)a[i++];
        JobState jobState = (JobState)((Object)((Object)a[i++]));
        ModelSizeStats modelSizeStats = (modelSizeStatsBuilder = (ModelSizeStats.Builder)a[i++]) == null ? null : modelSizeStatsBuilder.build();
        ForecastStats forecastStats = (ForecastStats)a[i++];
        NodeAttributes node = (NodeAttributes)a[i++];
        String assignmentExplanation = (String)a[i++];
        TimeValue openTime = (TimeValue)a[i];
        return new JobStats(jobId, dataCounts, jobState, modelSizeStats, forecastStats, node, assignmentExplanation, openTime);
    });
    private final String jobId;
    private final DataCounts dataCounts;
    private final JobState state;
    private final ModelSizeStats modelSizeStats;
    private final ForecastStats forecastStats;
    private final NodeAttributes node;
    private final String assignmentExplanation;
    private final TimeValue openTime;

    JobStats(String jobId, DataCounts dataCounts, JobState state, @Nullable ModelSizeStats modelSizeStats, @Nullable ForecastStats forecastStats, @Nullable NodeAttributes node, @Nullable String assignmentExplanation, @Nullable TimeValue opentime) {
        this.jobId = Objects.requireNonNull(jobId);
        this.dataCounts = Objects.requireNonNull(dataCounts);
        this.state = Objects.requireNonNull(state);
        this.modelSizeStats = modelSizeStats;
        this.forecastStats = forecastStats;
        this.node = node;
        this.assignmentExplanation = assignmentExplanation;
        this.openTime = opentime;
    }

    public String getJobId() {
        return this.jobId;
    }

    public DataCounts getDataCounts() {
        return this.dataCounts;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public ForecastStats getForecastStats() {
        return this.forecastStats;
    }

    public JobState getState() {
        return this.state;
    }

    public NodeAttributes getNode() {
        return this.node;
    }

    public String getAssignmentExplanation() {
        return this.assignmentExplanation;
    }

    public TimeValue getOpenTime() {
        return this.openTime;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(DATA_COUNTS.getPreferredName(), this.dataCounts);
        builder.field(STATE.getPreferredName(), this.state.toString());
        if (this.modelSizeStats != null) {
            builder.field(MODEL_SIZE_STATS.getPreferredName(), this.modelSizeStats);
        }
        if (this.forecastStats != null) {
            builder.field(FORECASTS_STATS.getPreferredName(), this.forecastStats);
        }
        if (this.node != null) {
            builder.field(NODE.getPreferredName(), this.node);
        }
        if (this.assignmentExplanation != null) {
            builder.field(ASSIGNMENT_EXPLANATION.getPreferredName(), this.assignmentExplanation);
        }
        if (this.openTime != null) {
            builder.field(OPEN_TIME.getPreferredName(), this.openTime.getStringRep());
        }
        return builder.endObject();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.dataCounts, this.modelSizeStats, this.forecastStats, this.state, this.node, this.assignmentExplanation, this.openTime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobStats other = (JobStats)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.dataCounts, other.dataCounts) && Objects.equals(this.modelSizeStats, other.modelSizeStats) && Objects.equals(this.forecastStats, other.forecastStats) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation) && Objects.equals(this.openTime, other.openTime);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), DataCounts.PARSER, DATA_COUNTS);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> JobState.fromString(p.text()), STATE, ObjectParser.ValueType.VALUE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ModelSizeStats.PARSER, MODEL_SIZE_STATS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ForecastStats.PARSER, FORECASTS_STATS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), NodeAttributes.PARSER, NODE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ASSIGNMENT_EXPLANATION);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.textOrNull(), OPEN_TIME.getPreferredName()), OPEN_TIME, ObjectParser.ValueType.STRING_OR_NULL);
    }
}

