/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.close;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.DestructiveOperations;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TransportCloseIndexAction
extends TransportMasterNodeAction<CloseIndexRequest, AcknowledgedResponse> {
    private final MetaDataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;
    private volatile boolean closeIndexEnabled;
    public static final Setting<Boolean> CLUSTER_INDICES_CLOSE_ENABLE_SETTING = Setting.boolSetting("cluster.indices.close.enable", true, Setting.Property.Dynamic, Setting.Property.NodeScope);

    @Inject
    public TransportCloseIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexStateService indexStateService, ClusterSettings clusterSettings, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super(settings, "indices:admin/close", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, CloseIndexRequest::new);
        this.indexStateService = indexStateService;
        this.destructiveOperations = destructiveOperations;
        this.closeIndexEnabled = CLUSTER_INDICES_CLOSE_ENABLE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_INDICES_CLOSE_ENABLE_SETTING, this::setCloseIndexEnabled);
    }

    private void setCloseIndexEnabled(boolean closeIndexEnabled) {
        this.closeIndexEnabled = closeIndexEnabled;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    @Override
    protected void doExecute(Task task, CloseIndexRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        if (!this.closeIndexEnabled) {
            throw new IllegalStateException("closing indices is forbidden since data in closed indices may be lost during migrations and upgrades, and they also consume significant disk space; set [" + CLUSTER_INDICES_CLOSE_ENABLE_SETTING.getKey() + ": true] to permit indices to be closed");
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(CloseIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(CloseIndexRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, CloseIndexRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        final Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(new AcknowledgedResponse(true));
            return;
        }
        CloseIndexClusterStateUpdateRequest closeRequest = (CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)new CloseIndexClusterStateUpdateRequest(task.getId()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices);
        this.indexStateService.closeIndices(closeRequest, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception t) {
                TransportCloseIndexAction.this.logger.debug(() -> new ParameterizedMessage("failed to close indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }
}

