/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRoutingState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.UnassignedInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;

public final class ClusterAllocationExplanation
implements ToXContentObject,
Writeable {
    private final ShardRouting shardRouting;
    private final DiscoveryNode currentNode;
    private final DiscoveryNode relocationTargetNode;
    private final ClusterInfo clusterInfo;
    private final ShardAllocationDecision shardAllocationDecision;

    public ClusterAllocationExplanation(ShardRouting shardRouting, @Nullable DiscoveryNode currentNode, @Nullable DiscoveryNode relocationTargetNode, @Nullable ClusterInfo clusterInfo, ShardAllocationDecision shardAllocationDecision) {
        this.shardRouting = shardRouting;
        this.currentNode = currentNode;
        this.relocationTargetNode = relocationTargetNode;
        this.clusterInfo = clusterInfo;
        this.shardAllocationDecision = shardAllocationDecision;
    }

    public ClusterAllocationExplanation(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.currentNode = in.readOptionalWriteable(DiscoveryNode::new);
        this.relocationTargetNode = in.readOptionalWriteable(DiscoveryNode::new);
        this.clusterInfo = in.readOptionalWriteable(ClusterInfo::new);
        this.shardAllocationDecision = new ShardAllocationDecision(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        out.writeOptionalWriteable(this.currentNode);
        out.writeOptionalWriteable(this.relocationTargetNode);
        out.writeOptionalWriteable(this.clusterInfo);
        this.shardAllocationDecision.writeTo(out);
    }

    public ShardId getShard() {
        return this.shardRouting.shardId();
    }

    public boolean isPrimary() {
        return this.shardRouting.primary();
    }

    public ShardRoutingState getShardState() {
        return this.shardRouting.state();
    }

    @Nullable
    public DiscoveryNode getCurrentNode() {
        return this.currentNode;
    }

    @Nullable
    public DiscoveryNode getRelocationTargetNode() {
        return this.relocationTargetNode;
    }

    @Nullable
    public UnassignedInfo getUnassignedInfo() {
        return this.shardRouting.unassignedInfo();
    }

    @Nullable
    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public ShardAllocationDecision getShardAllocationDecision() {
        return this.shardAllocationDecision;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.shardRouting.getIndexName());
        builder.field("shard", this.shardRouting.getId());
        builder.field("primary", this.shardRouting.primary());
        builder.field("current_state", this.shardRouting.state().toString().toLowerCase(Locale.ROOT));
        if (this.shardRouting.unassignedInfo() != null) {
            this.unassignedInfoToXContent(this.shardRouting.unassignedInfo(), builder);
        }
        if (this.currentNode != null) {
            builder.startObject("current_node");
            AbstractAllocationDecision.discoveryNodeToXContent(this.currentNode, true, builder);
            if (this.shardAllocationDecision.getMoveDecision().isDecisionTaken() && this.shardAllocationDecision.getMoveDecision().getCurrentNodeRanking() > 0) {
                builder.field("weight_ranking", this.shardAllocationDecision.getMoveDecision().getCurrentNodeRanking());
            }
            builder.endObject();
        }
        if (this.clusterInfo != null) {
            builder.startObject("cluster_info");
            this.clusterInfo.toXContent(builder, params);
            builder.endObject();
        }
        if (this.shardAllocationDecision.isDecisionTaken()) {
            this.shardAllocationDecision.toXContent(builder, params);
        } else {
            String explanation;
            if (this.shardRouting.state() == ShardRoutingState.RELOCATING) {
                explanation = "the shard is in the process of relocating from node [" + this.currentNode.getName() + "] to node [" + this.relocationTargetNode.getName() + "], wait until relocation has completed";
            } else {
                assert (this.shardRouting.state() == ShardRoutingState.INITIALIZING);
                explanation = "the shard is in the process of initializing on node [" + this.currentNode.getName() + "], wait until initialization has completed";
            }
            builder.field("explanation", explanation);
        }
        builder.endObject();
        return builder;
    }

    private XContentBuilder unassignedInfoToXContent(UnassignedInfo unassignedInfo, XContentBuilder builder) throws IOException {
        String details;
        builder.startObject("unassigned_info");
        builder.field("reason", (Object)unassignedInfo.getReason());
        builder.field("at", UnassignedInfo.DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(unassignedInfo.getUnassignedTimeInMillis())));
        if (unassignedInfo.getNumFailedAllocations() > 0) {
            builder.field("failed_allocation_attempts", unassignedInfo.getNumFailedAllocations());
        }
        if ((details = unassignedInfo.getDetails()) != null) {
            builder.field("details", details);
        }
        builder.field("last_allocation_status", AllocationDecision.fromAllocationStatus(unassignedInfo.getLastAllocationStatus()));
        builder.endObject();
        return builder;
    }
}

