/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action;

import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.Action;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionFuture;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ElasticsearchClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> {
    protected final Action<Request, Response, RequestBuilder> action;
    protected final Request request;
    protected final ElasticsearchClient client;

    protected ActionRequestBuilder(ElasticsearchClient client, Action<Request, Response, RequestBuilder> action, Request request) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
    }

    public Request request() {
        return this.request;
    }

    public ActionFuture<Response> execute() {
        return this.client.execute(this.action, this.request);
    }

    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.request, listener);
    }
}

