/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Objects;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.FileSystemUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class Build {
    public static final Build CURRENT;
    private final boolean isSnapshot;
    private final Flavor flavor;
    private final Type type;
    private final String shortHash;
    private final String date;

    static URL getElasticsearchCodeSourceLocation() {
        CodeSource codeSource = Build.class.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    public Build(Flavor flavor, Type type, String shortHash, String date, boolean isSnapshot) {
        this.flavor = flavor;
        this.type = type;
        this.shortHash = shortHash;
        this.date = date;
        this.isSnapshot = isSnapshot;
    }

    public String shortHash() {
        return this.shortHash;
    }

    public String date() {
        return this.date;
    }

    public static Build readBuild(StreamInput in) throws IOException {
        Flavor flavor = in.getVersion().onOrAfter(Version.V_6_3_0) ? Flavor.fromDisplayName(in.readString(), false) : Flavor.OSS;
        Type type = in.getVersion().onOrAfter(Version.V_6_3_0) ? Type.fromDisplayName(in.readString(), false) : Type.UNKNOWN;
        String hash = in.readString();
        String date = in.readString();
        boolean snapshot = in.readBoolean();
        return new Build(flavor, type, hash, date, snapshot);
    }

    public static void writeBuild(Build build, StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeString(build.flavor().displayName());
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            Type buildType = out.getVersion().before(Version.V_6_7_0) && build.type() == Type.DOCKER ? Type.TAR : build.type();
            out.writeString(buildType.displayName());
        }
        out.writeString(build.shortHash());
        out.writeString(build.date());
        out.writeBoolean(build.isSnapshot());
    }

    public Flavor flavor() {
        return this.flavor;
    }

    public Type type() {
        return this.type;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public String toString() {
        return "[" + this.flavor.displayName() + "][" + this.type.displayName + "][" + this.shortHash + "][" + this.date + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        if (!this.flavor.equals((Object)build.flavor)) {
            return false;
        }
        if (!this.type.equals((Object)build.type)) {
            return false;
        }
        if (this.isSnapshot != build.isSnapshot) {
            return false;
        }
        if (!this.shortHash.equals(build.shortHash)) {
            return false;
        }
        return this.date.equals(build.date);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flavor, this.type, this.isSnapshot, this.shortHash, this.date});
    }

    static {
        boolean isSnapshot;
        String date;
        String shortHash;
        Type type;
        Flavor flavor;
        block14: {
            String urlStr;
            flavor = Flavor.fromDisplayName(System.getProperty("es.distribution.flavor", "unknown"), true);
            type = Type.fromDisplayName(System.getProperty("es.distribution.type", "unknown"), true);
            String esPrefix = "elasticsearch-" + Version.CURRENT;
            URL url = Build.getElasticsearchCodeSourceLocation();
            String string = urlStr = url == null ? "" : url.toString();
            if (urlStr.startsWith("file:/") && (urlStr.endsWith(esPrefix + ".jar") || urlStr.endsWith(esPrefix + "-SNAPSHOT.jar"))) {
                try (JarInputStream jar = new JarInputStream(FileSystemUtils.openFileURLStream(url));){
                    Manifest manifest = jar.getManifest();
                    shortHash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    isSnapshot = "true".equals(manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Snapshot"));
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            shortHash = "Unknown";
            date = "Unknown";
            String buildSnapshot = System.getProperty("build.snapshot");
            if (buildSnapshot != null) {
                try {
                    Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("build.snapshot set to [" + buildSnapshot + "] but not running tests");
                }
                isSnapshot = Booleans.parseBoolean(buildSnapshot);
            } else {
                isSnapshot = true;
            }
        }
        if (shortHash == null) {
            throw new IllegalStateException("Error finding the build shortHash. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (date == null) {
            throw new IllegalStateException("Error finding the build date. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        CURRENT = new Build(flavor, type, shortHash, date, isSnapshot);
    }

    public static enum Type {
        DEB("deb"),
        DOCKER("docker"),
        RPM("rpm"),
        TAR("tar"),
        ZIP("zip"),
        UNKNOWN("unknown");

        final String displayName;

        public String displayName() {
            return this.displayName;
        }

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public static Type fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "deb": {
                    return DEB;
                }
                case "docker": {
                    return DOCKER;
                }
                case "rpm": {
                    return RPM;
                }
                case "tar": {
                    return TAR;
                }
                case "zip": {
                    return ZIP;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                throw new IllegalStateException("unexpected distribution type [" + displayName + "]; your distribution is broken");
            }
            return UNKNOWN;
        }
    }

    public static enum Flavor {
        DEFAULT("default"),
        OSS("oss"),
        UNKNOWN("unknown");

        final String displayName;

        private Flavor(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }

        public static Flavor fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "default": {
                    return DEFAULT;
                }
                case "oss": {
                    return OSS;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                String message = "unexpected distribution flavor [" + displayName + "]; your distribution is broken";
                throw new IllegalStateException(message);
            }
            return UNKNOWN;
        }
    }
}

