/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoBasePath;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Vector;

class GeoStandardPath
extends GeoBasePath {
    protected final double cutoffAngle;
    protected final double sinAngle;
    protected final double cosAngle;
    protected final List<GeoPoint> points = new ArrayList<GeoPoint>();
    protected List<SegmentEndpoint> endPoints;
    protected List<PathSegment> segments;
    protected GeoPoint[] edgePoints;
    protected boolean isDone = false;

    public GeoStandardPath(PlanetModel planetModel, double maxCutoffAngle, GeoPoint[] pathPoints) {
        this(planetModel, maxCutoffAngle);
        Collections.addAll(this.points, pathPoints);
        this.done();
    }

    public GeoStandardPath(PlanetModel planetModel, double maxCutoffAngle) {
        super(planetModel);
        if (maxCutoffAngle <= 0.0 || maxCutoffAngle > 1.5707963267948966) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        this.cutoffAngle = maxCutoffAngle;
        this.cosAngle = Math.cos(maxCutoffAngle);
        this.sinAngle = Math.sin(maxCutoffAngle);
    }

    public void addPoint(double lat, double lon) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        this.points.add(new GeoPoint(this.planetModel, lat, lon));
    }

    public void done() {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() twice");
        }
        if (this.points.size() == 0) {
            throw new IllegalArgumentException("Path must have at least one point");
        }
        this.isDone = true;
        this.endPoints = new ArrayList<SegmentEndpoint>(this.points.size());
        this.segments = new ArrayList<PathSegment>(this.points.size());
        double cutoffOffset = this.sinAngle * this.planetModel.getMinimumMagnitude();
        GeoPoint lastPoint = null;
        for (GeoPoint end : this.points) {
            if (lastPoint != null) {
                Plane normalizedConnectingPlane = new Plane((Vector)lastPoint, end);
                if (normalizedConnectingPlane == null) continue;
                this.segments.add(new PathSegment(this.planetModel, lastPoint, end, normalizedConnectingPlane, cutoffOffset));
            }
            lastPoint = end;
        }
        if (this.segments.size() == 0) {
            double lat = this.points.get(0).getLatitude();
            double lon = this.points.get(0).getLongitude();
            double upperLat = lat + this.cutoffAngle;
            double upperLon = lon;
            if (upperLat > 1.5707963267948966) {
                if ((upperLon += Math.PI) > Math.PI) {
                    upperLon -= Math.PI * 2;
                }
                upperLat = Math.PI - upperLat;
            }
            double lowerLat = lat - this.cutoffAngle;
            double lowerLon = lon;
            if (lowerLat < -1.5707963267948966) {
                if ((lowerLon += Math.PI) > Math.PI) {
                    lowerLon -= Math.PI * 2;
                }
                lowerLat = -Math.PI - lowerLat;
            }
            GeoPoint upperPoint = new GeoPoint(this.planetModel, upperLat, upperLon);
            GeoPoint lowerPoint = new GeoPoint(this.planetModel, lowerLat, lowerLon);
            GeoPoint point = this.points.get(0);
            Plane normalPlane = Plane.constructNormalizedZPlane(upperPoint, lowerPoint, point);
            CircleSegmentEndpoint onlyEndpoint = new CircleSegmentEndpoint(point, normalPlane, upperPoint, lowerPoint);
            this.endPoints.add(onlyEndpoint);
            this.edgePoints = new GeoPoint[]{onlyEndpoint.circlePlane.getSampleIntersectionPoint(this.planetModel, normalPlane)};
            return;
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            PathSegment currentSegment = this.segments.get(i);
            if (i == 0) {
                CutoffSingleCircleSegmentEndpoint startEndpoint = new CutoffSingleCircleSegmentEndpoint(currentSegment.start, currentSegment.startCutoffPlane, currentSegment.ULHC, currentSegment.LLHC);
                this.endPoints.add(startEndpoint);
                this.edgePoints = new GeoPoint[]{currentSegment.ULHC};
                continue;
            }
            PathSegment prevSegment = this.segments.get(i - 1);
            if (prevSegment.endCutoffPlane.isWithin(currentSegment.ULHC) && prevSegment.endCutoffPlane.isWithin(currentSegment.LLHC) && currentSegment.startCutoffPlane.isWithin(prevSegment.URHC) && currentSegment.startCutoffPlane.isWithin(prevSegment.LRHC)) {
                CutoffSingleCircleSegmentEndpoint midEndpoint = new CutoffSingleCircleSegmentEndpoint(currentSegment.start, prevSegment.endCutoffPlane, currentSegment.startCutoffPlane, currentSegment.ULHC, currentSegment.LLHC);
                this.endPoints.add(midEndpoint);
                continue;
            }
            this.endPoints.add(new CutoffDualCircleSegmentEndpoint(currentSegment.start, prevSegment.endCutoffPlane, currentSegment.startCutoffPlane, prevSegment.URHC, prevSegment.LRHC, currentSegment.ULHC, currentSegment.LLHC));
        }
        PathSegment lastSegment = this.segments.get(this.segments.size() - 1);
        this.endPoints.add(new CutoffSingleCircleSegmentEndpoint(lastSegment.end, lastSegment.endCutoffPlane, lastSegment.URHC, lastSegment.LRHC));
    }

    public GeoStandardPath(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readPointArray(planetModel, inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.cutoffAngle);
        SerializableObject.writePointArray(outputStream, this.points);
    }

    @Override
    public double computePathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double closestDistance = Double.POSITIVE_INFINITY;
        for (PathSegment segment : this.segments) {
            double segmentDistance = segment.pathCenterDistance(this.planetModel, distanceStyle, x, y, z);
            if (!(segmentDistance < closestDistance)) continue;
            closestDistance = segmentDistance;
        }
        for (SegmentEndpoint endpoint : this.endPoints) {
            double endpointDistance = endpoint.pathCenterDistance(distanceStyle, x, y, z);
            if (!(endpointDistance < closestDistance)) continue;
            closestDistance = endpointDistance;
        }
        return closestDistance;
    }

    @Override
    public double computeNearestDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double currentDistance = 0.0;
        double minPathCenterDistance = Double.POSITIVE_INFINITY;
        double bestDistance = Double.POSITIVE_INFINITY;
        int segmentIndex = 0;
        for (SegmentEndpoint endpoint : this.endPoints) {
            double endpointPathCenterDistance = endpoint.pathCenterDistance(distanceStyle, x, y, z);
            if (endpointPathCenterDistance < minPathCenterDistance) {
                minPathCenterDistance = endpointPathCenterDistance;
                bestDistance = currentDistance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            int n = segmentIndex++;
            PathSegment segment = this.segments.get(n);
            double segmentPathCenterDistance = segment.pathCenterDistance(this.planetModel, distanceStyle, x, y, z);
            if (segmentPathCenterDistance < minPathCenterDistance) {
                minPathCenterDistance = segmentPathCenterDistance;
                bestDistance = distanceStyle.aggregateDistances(currentDistance, segment.nearestPathDistance(this.planetModel, distanceStyle, x, y, z));
            }
            currentDistance = distanceStyle.aggregateDistances(currentDistance, segment.fullPathDistance(distanceStyle));
        }
        return bestDistance;
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        double bestDistance = Double.POSITIVE_INFINITY;
        double currentDistance = 0.0;
        for (PathSegment segment : this.segments) {
            double thisDistance;
            double distance = segment.pathDistance(this.planetModel, distanceStyle, x, y, z);
            if (distance != Double.POSITIVE_INFINITY && (thisDistance = distanceStyle.fromAggregationForm(distanceStyle.aggregateDistances(currentDistance, distance))) < bestDistance) {
                bestDistance = thisDistance;
            }
            currentDistance = distanceStyle.aggregateDistances(currentDistance, segment.fullPathDistance(distanceStyle));
        }
        int segmentIndex = 0;
        currentDistance = 0.0;
        for (SegmentEndpoint endpoint : this.endPoints) {
            double thisDistance;
            double distance = endpoint.pathDistance(distanceStyle, x, y, z);
            if (distance != Double.POSITIVE_INFINITY && (thisDistance = distanceStyle.fromAggregationForm(distanceStyle.aggregateDistances(currentDistance, distance))) < bestDistance) {
                bestDistance = thisDistance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            currentDistance = distanceStyle.aggregateDistances(currentDistance, this.segments.get(segmentIndex++).fullPathDistance(distanceStyle));
        }
        return bestDistance;
    }

    @Override
    protected double deltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double thisDistance;
        double distance;
        double bestDistance = Double.POSITIVE_INFINITY;
        for (PathSegment segment : this.segments) {
            distance = segment.pathDeltaDistance(this.planetModel, distanceStyle, x, y, z);
            if (distance == Double.POSITIVE_INFINITY || !((thisDistance = distanceStyle.fromAggregationForm(distance)) < bestDistance)) continue;
            bestDistance = thisDistance;
        }
        for (SegmentEndpoint endpoint : this.endPoints) {
            distance = endpoint.pathDeltaDistance(distanceStyle, x, y, z);
            if (distance == Double.POSITIVE_INFINITY || !((thisDistance = distanceStyle.fromAggregationForm(distance)) < bestDistance)) continue;
            bestDistance = thisDistance;
        }
        return bestDistance;
    }

    @Override
    protected void distanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        this.getBounds(bounds);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double newDistance;
        double minDistance = Double.POSITIVE_INFINITY;
        for (SegmentEndpoint endpoint : this.endPoints) {
            newDistance = endpoint.outsideDistance(distanceStyle, x, y, z);
            if (!(newDistance < minDistance)) continue;
            minDistance = newDistance;
        }
        for (PathSegment segment : this.segments) {
            newDistance = segment.outsideDistance(this.planetModel, distanceStyle, x, y, z);
            if (!(newDistance < minDistance)) continue;
            minDistance = newDistance;
        }
        return minDistance;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (SegmentEndpoint pathPoint : this.endPoints) {
            if (!pathPoint.isWithin(x, y, z)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        for (SegmentEndpoint pathPoint : this.endPoints) {
            if (!pathPoint.intersects(this.planetModel, plane, notablePoints, bounds)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.intersects(this.planetModel, plane, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        for (SegmentEndpoint pathPoint : this.endPoints) {
            if (!pathPoint.intersects(geoShape)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.intersects(geoShape)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        for (PathSegment pathSegment : this.segments) {
            pathSegment.getBounds(this.planetModel, bounds);
        }
        for (SegmentEndpoint pathPoint : this.endPoints) {
            pathPoint.getBounds(this.planetModel, bounds);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoStandardPath)) {
            return false;
        }
        GeoStandardPath p = (GeoStandardPath)o;
        if (!super.equals(p)) {
            return false;
        }
        if (this.cutoffAngle != p.cutoffAngle) {
            return false;
        }
        return this.points.equals(p.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        return "GeoStandardPath: {planetmodel=" + this.planetModel + ", width=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + "), points={" + this.points + "}}";
    }

    private static class PathSegment {
        public final GeoPoint start;
        public final GeoPoint end;
        public final Map<DistanceStyle, Double> fullDistanceCache = new HashMap<DistanceStyle, Double>();
        public final Plane normalizedConnectingPlane;
        public final SidedPlane upperConnectingPlane;
        public final SidedPlane lowerConnectingPlane;
        public final SidedPlane startCutoffPlane;
        public final SidedPlane endCutoffPlane;
        public final GeoPoint URHC;
        public final GeoPoint LRHC;
        public final GeoPoint ULHC;
        public final GeoPoint LLHC;
        public final GeoPoint[] upperConnectingPlanePoints;
        public final GeoPoint[] lowerConnectingPlanePoints;
        public final GeoPoint[] startCutoffPlanePoints;
        public final GeoPoint[] endCutoffPlanePoints;

        public PathSegment(PlanetModel planetModel, GeoPoint start, GeoPoint end, Plane normalizedConnectingPlane, double planeBoundingOffset) {
            this.start = start;
            this.end = end;
            this.normalizedConnectingPlane = normalizedConnectingPlane;
            this.upperConnectingPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, -planeBoundingOffset);
            this.lowerConnectingPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, planeBoundingOffset);
            this.startCutoffPlane = new SidedPlane((Vector)end, (Vector)normalizedConnectingPlane, start);
            this.endCutoffPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, end);
            Membership[] upperSide = new Membership[]{this.upperConnectingPlane};
            Membership[] lowerSide = new Membership[]{this.lowerConnectingPlane};
            Membership[] startSide = new Membership[]{this.startCutoffPlane};
            Membership[] endSide = new Membership[]{this.endCutoffPlane};
            GeoPoint[] points = this.upperConnectingPlane.findIntersections(planetModel, (Plane)this.startCutoffPlane, lowerSide, endSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.ULHC = points[0];
            points = this.upperConnectingPlane.findIntersections(planetModel, (Plane)this.endCutoffPlane, lowerSide, startSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.URHC = points[0];
            points = this.lowerConnectingPlane.findIntersections(planetModel, (Plane)this.startCutoffPlane, upperSide, endSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.LLHC = points[0];
            points = this.lowerConnectingPlane.findIntersections(planetModel, (Plane)this.endCutoffPlane, upperSide, startSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.LRHC = points[0];
            this.upperConnectingPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
            this.lowerConnectingPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
            this.startCutoffPlanePoints = new GeoPoint[]{this.ULHC, this.LLHC};
            this.endCutoffPlanePoints = new GeoPoint[]{this.URHC, this.LRHC};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double fullPathDistance(DistanceStyle distanceStyle) {
            Map<DistanceStyle, Double> map = this.fullDistanceCache;
            synchronized (map) {
                Double dist = this.fullDistanceCache.get(distanceStyle);
                if (dist == null) {
                    dist = distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, this.end.x, this.end.y, this.end.z));
                    this.fullDistanceCache.put(distanceStyle, dist);
                }
                return dist;
            }
        }

        public boolean isWithin(Vector point) {
            return this.startCutoffPlane.isWithin(point) && this.endCutoffPlane.isWithin(point) && this.upperConnectingPlane.isWithin(point) && this.lowerConnectingPlane.isWithin(point);
        }

        public boolean isWithin(double x, double y, double z) {
            return this.startCutoffPlane.isWithin(x, y, z) && this.endCutoffPlane.isWithin(x, y, z) && this.upperConnectingPlane.isWithin(x, y, z) && this.lowerConnectingPlane.isWithin(x, y, z);
        }

        public double pathCenterDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.startCutoffPlane.isWithin(x, y, z) || !this.endCutoffPlane.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.computeDistance(this.start, x, y, z);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.computeDistance(thePoint, x, y, z);
        }

        public double nearestPathDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.startCutoffPlane.isWithin(x, y, z) || !this.endCutoffPlane.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.toAggregationForm(0.0);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z));
        }

        public double pathDeltaDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                double theDistance = distanceStyle.computeDistance(this.start, x, y, z);
                return distanceStyle.aggregateDistances(theDistance, theDistance);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            double theDistance = distanceStyle.toAggregationForm(distanceStyle.computeDistance(thePoint, x, y, z));
            return distanceStyle.aggregateDistances(theDistance, theDistance);
        }

        public double pathDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, x, y, z));
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.aggregateDistances(distanceStyle.toAggregationForm(distanceStyle.computeDistance(thePoint, x, y, z)), distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z)));
        }

        public double outsideDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            double upperDistance = distanceStyle.computeDistance(planetModel, (Plane)this.upperConnectingPlane, x, y, z, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            double lowerDistance = distanceStyle.computeDistance(planetModel, (Plane)this.lowerConnectingPlane, x, y, z, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            double startDistance = distanceStyle.computeDistance(planetModel, (Plane)this.startCutoffPlane, x, y, z, this.endCutoffPlane, this.lowerConnectingPlane, this.upperConnectingPlane);
            double endDistance = distanceStyle.computeDistance(planetModel, (Plane)this.endCutoffPlane, x, y, z, this.startCutoffPlane, this.lowerConnectingPlane, this.upperConnectingPlane);
            double ULHCDistance = distanceStyle.computeDistance(this.ULHC, x, y, z);
            double URHCDistance = distanceStyle.computeDistance(this.URHC, x, y, z);
            double LLHCDistance = distanceStyle.computeDistance(this.LLHC, x, y, z);
            double LRHCDistance = distanceStyle.computeDistance(this.LRHC, x, y, z);
            return Math.min(Math.min(Math.min(upperDistance, lowerDistance), Math.min(startDistance, endDistance)), Math.min(Math.min(ULHCDistance, URHCDistance), Math.min(LLHCDistance, LRHCDistance)));
        }

        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.upperConnectingPlane.intersects(planetModel, p, notablePoints, this.upperConnectingPlanePoints, bounds, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane) || this.lowerConnectingPlane.intersects(planetModel, p, notablePoints, this.lowerConnectingPlanePoints, bounds, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }

        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.upperConnectingPlane, this.upperConnectingPlanePoints, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane) || geoShape.intersects(this.lowerConnectingPlane, this.lowerConnectingPlanePoints, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }

        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            bounds.addPoint(this.start).addPoint(this.end).addPoint(this.ULHC).addPoint(this.URHC).addPoint(this.LRHC).addPoint(this.LLHC).addPlane(planetModel, this.upperConnectingPlane, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane).addPlane(planetModel, this.lowerConnectingPlane, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane).addPlane(planetModel, this.startCutoffPlane, this.endCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane).addPlane(planetModel, this.endCutoffPlane, this.startCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane).addIntersection(planetModel, this.upperConnectingPlane, this.startCutoffPlane, this.lowerConnectingPlane, this.endCutoffPlane).addIntersection(planetModel, this.startCutoffPlane, this.lowerConnectingPlane, this.endCutoffPlane, this.upperConnectingPlane).addIntersection(planetModel, this.lowerConnectingPlane, this.endCutoffPlane, this.upperConnectingPlane, this.startCutoffPlane).addIntersection(planetModel, this.endCutoffPlane, this.upperConnectingPlane, this.startCutoffPlane, this.lowerConnectingPlane);
        }
    }

    private static class CutoffDualCircleSegmentEndpoint
    extends BaseSegmentEndpoint {
        protected final SidedPlane circlePlane1;
        protected final SidedPlane circlePlane2;
        protected final GeoPoint[] notablePoints1;
        protected final GeoPoint[] notablePoints2;
        protected final Membership[] cutoffPlanes;

        public CutoffDualCircleSegmentEndpoint(GeoPoint point, SidedPlane prevCutoffPlane, SidedPlane nextCutoffPlane, GeoPoint prevURHC, GeoPoint prevLRHC, GeoPoint currentULHC, GeoPoint currentLLHC) {
            super(point);
            if (!prevCutoffPlane.isWithin(currentULHC)) {
                this.circlePlane1 = SidedPlane.constructNormalizedThreePointSidedPlane(point, prevURHC, prevLRHC, currentULHC);
                this.notablePoints1 = new GeoPoint[]{prevURHC, prevLRHC, currentULHC};
            } else if (!prevCutoffPlane.isWithin(currentLLHC)) {
                this.circlePlane1 = SidedPlane.constructNormalizedThreePointSidedPlane(point, prevURHC, prevLRHC, currentLLHC);
                this.notablePoints1 = new GeoPoint[]{prevURHC, prevLRHC, currentLLHC};
            } else {
                throw new IllegalArgumentException("Constructing CutoffDualCircleSegmentEndpoint with colinear segments");
            }
            if (!nextCutoffPlane.isWithin(prevURHC)) {
                this.circlePlane2 = SidedPlane.constructNormalizedThreePointSidedPlane(point, currentULHC, currentLLHC, prevURHC);
                this.notablePoints2 = new GeoPoint[]{currentULHC, currentLLHC, prevURHC};
            } else if (!nextCutoffPlane.isWithin(prevLRHC)) {
                this.circlePlane2 = SidedPlane.constructNormalizedThreePointSidedPlane(point, currentULHC, currentLLHC, prevLRHC);
                this.notablePoints2 = new GeoPoint[]{currentULHC, currentLLHC, prevLRHC};
            } else {
                throw new IllegalArgumentException("Constructing CutoffDualCircleSegmentEndpoint with colinear segments");
            }
            this.cutoffPlanes = new Membership[]{new SidedPlane(prevCutoffPlane), new SidedPlane(nextCutoffPlane)};
        }

        @Override
        public boolean isWithin(Vector point) {
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(point)) continue;
                return false;
            }
            return this.circlePlane1.isWithin(point) || this.circlePlane2.isWithin(point);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(x, y, z)) continue;
                return false;
            }
            return this.circlePlane1.isWithin(x, y, z) || this.circlePlane2.isWithin(x, y, z);
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(x, y, z)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return super.nearestPathDistance(distanceStyle, x, y, z);
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(x, y, z)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return super.pathCenterDistance(distanceStyle, x, y, z);
        }

        @Override
        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane1.intersects(planetModel, p, notablePoints, this.notablePoints1, bounds, this.cutoffPlanes) || this.circlePlane2.intersects(planetModel, p, notablePoints, this.notablePoints2, bounds, this.cutoffPlanes);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.circlePlane1, this.notablePoints1, this.cutoffPlanes) || geoShape.intersects(this.circlePlane2, this.notablePoints2, this.cutoffPlanes);
        }

        @Override
        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            super.getBounds(planetModel, bounds);
            bounds.addPlane(planetModel, this.circlePlane1, new Membership[0]);
            bounds.addPlane(planetModel, this.circlePlane2, new Membership[0]);
        }
    }

    private static class CutoffSingleCircleSegmentEndpoint
    extends CircleSegmentEndpoint {
        protected final Membership[] cutoffPlanes;
        private final GeoPoint[] notablePoints;

        public CutoffSingleCircleSegmentEndpoint(GeoPoint point, SidedPlane cutoffPlane, GeoPoint topEdgePoint, GeoPoint bottomEdgePoint) {
            super(point, cutoffPlane, topEdgePoint, bottomEdgePoint);
            this.cutoffPlanes = new Membership[]{new SidedPlane(cutoffPlane)};
            this.notablePoints = new GeoPoint[]{topEdgePoint, bottomEdgePoint};
        }

        public CutoffSingleCircleSegmentEndpoint(GeoPoint point, SidedPlane cutoffPlane1, SidedPlane cutoffPlane2, GeoPoint topEdgePoint, GeoPoint bottomEdgePoint) {
            super(point, cutoffPlane1, topEdgePoint, bottomEdgePoint);
            this.cutoffPlanes = new Membership[]{new SidedPlane(cutoffPlane1), new SidedPlane(cutoffPlane2)};
            this.notablePoints = new GeoPoint[]{topEdgePoint, bottomEdgePoint};
        }

        @Override
        public boolean isWithin(Vector point) {
            if (!super.isWithin(point)) {
                return false;
            }
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(point)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            if (!super.isWithin(x, y, z)) {
                return false;
            }
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(x, y, z)) continue;
                return false;
            }
            return true;
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(x, y, z)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return super.nearestPathDistance(distanceStyle, x, y, z);
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            for (Membership m3 : this.cutoffPlanes) {
                if (m3.isWithin(x, y, z)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return super.pathCenterDistance(distanceStyle, x, y, z);
        }

        @Override
        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane.intersects(planetModel, p, notablePoints, this.notablePoints, bounds, this.cutoffPlanes);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.circlePlane, this.notablePoints, this.cutoffPlanes);
        }
    }

    private static class CircleSegmentEndpoint
    extends BaseSegmentEndpoint {
        protected final SidedPlane circlePlane;
        protected static final GeoPoint[] circlePoints = new GeoPoint[0];

        public CircleSegmentEndpoint(GeoPoint point, Plane normalPlane, GeoPoint upperPoint, GeoPoint lowerPoint) {
            super(point);
            this.circlePlane = SidedPlane.constructNormalizedPerpendicularSidedPlane(point, normalPlane, upperPoint, lowerPoint);
        }

        protected CircleSegmentEndpoint(GeoPoint point, SidedPlane circlePlane) {
            super(point);
            this.circlePlane = circlePlane;
        }

        @Override
        public boolean isWithin(Vector point) {
            return this.circlePlane.isWithin(point);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.circlePlane.isWithin(x, y, z);
        }

        @Override
        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane.intersects(planetModel, p, notablePoints, circlePoints, bounds, new Membership[0]);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.circlePlane, circlePoints, NO_MEMBERSHIP);
        }

        @Override
        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            super.getBounds(planetModel, bounds);
            bounds.addPlane(planetModel, this.circlePlane, new Membership[0]);
        }
    }

    private static class DegenerateSegmentEndpoint
    extends BaseSegmentEndpoint {
        public DegenerateSegmentEndpoint(GeoPoint point) {
            super(point);
        }
    }

    private static class BaseSegmentEndpoint
    implements SegmentEndpoint {
        protected final GeoPoint point;
        protected static final Membership[] NO_MEMBERSHIP = new Membership[0];

        public BaseSegmentEndpoint(GeoPoint point) {
            this.point = point;
        }

        @Override
        public boolean isWithin(Vector point) {
            return false;
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return false;
        }

        @Override
        public double pathDeltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double theDistance = distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
            return distanceStyle.aggregateDistances(theDistance, theDistance);
        }

        @Override
        public double pathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return distanceStyle.toAggregationForm(0.0);
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return distanceStyle.computeDistance(this.point, x, y, z);
        }

        @Override
        public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return distanceStyle.computeDistance(this.point, x, y, z);
        }

        @Override
        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return false;
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return false;
        }

        @Override
        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            bounds.addPoint(this.point);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BaseSegmentEndpoint)) {
                return false;
            }
            BaseSegmentEndpoint other = (BaseSegmentEndpoint)o;
            return this.point.equals(other.point);
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public String toString() {
            return this.point.toString();
        }
    }

    private static interface SegmentEndpoint {
        public boolean isWithin(Vector var1);

        public boolean isWithin(double var1, double var3, double var5);

        public double pathDeltaDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double pathDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double nearestPathDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double pathCenterDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double outsideDistance(DistanceStyle var1, double var2, double var4, double var6);

        public boolean intersects(PlanetModel var1, Plane var2, GeoPoint[] var3, Membership[] var4);

        public boolean intersects(GeoShape var1);

        public void getBounds(PlanetModel var1, Bounds var2);
    }
}

