/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.Cell;

public abstract class CellIterator
implements Iterator<Cell> {
    protected Cell nextCell;
    protected Cell thisCell;

    public Cell thisCell() {
        assert (this.thisCell != null) : "Only call thisCell() after next(), not hasNext()";
        return this.thisCell;
    }

    public Cell nextFrom(Cell fromCell) {
        Cell c;
        do {
            if (this.hasNext()) continue;
            return null;
        } while ((c = this.next()).compareToNoLeaf(fromCell) < 0);
        return c;
    }

    @Override
    public void remove() {
        assert (this.thisCell != null);
    }

    @Override
    public Cell next() {
        if (this.nextCell == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.thisCell = this.nextCell;
        this.nextCell = null;
        return this.thisCell;
    }
}

